/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.security.auth.trustedapps.ApplicationCertificate;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.atlassian.security.auth.trustedapps.UserResolver;
import com.atlassian.seraph.filter.TrustedApplicationsFilter;
import java.security.Principal;
import java.util.Optional;

public class TrustedApplicationFilter
extends TrustedApplicationsFilter {
    public TrustedApplicationFilter() {
        super((TrustedApplicationsManager)new DelegateManager(), (UserResolver)new JiraUserResolver());
    }

    static class DelegateManager
    implements TrustedApplicationsManager {
        DelegateManager() {
        }

        public TrustedApplication getTrustedApplication(String id) {
            return DelegateManager.getDelegate().map(delegate -> delegate.getTrustedApplication(id)).orElse(null);
        }

        public CurrentApplication getCurrentApplication() {
            return DelegateManager.getDelegate().map(TrustedApplicationsManager::getCurrentApplication).orElse(null);
        }

        private static Optional<TrustedApplicationsManager> getDelegate() {
            return ComponentAccessor.getComponentSafely(TrustedApplicationsManager.class);
        }
    }

    static class JiraUserResolver
    implements UserResolver {
        JiraUserResolver() {
        }

        public Principal resolve(ApplicationCertificate certificate) {
            Assertions.notNull((String)"certificate", (Object)certificate);
            return ComponentAccessor.getComponentSafely(UserManager.class).map(userManager -> userManager.getUserByName(certificate.getUserName())).orElse(null);
        }
    }
}

