/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.jwt;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtGenerateSecretException;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtParseException;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtSecretKeyService;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtSecurityException;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtToken;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtTokenBuilder;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtTokenGenerateParams;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageAttachmentJwtTokenService {
    @VisibleForTesting
    public static final long TOKENS_DISABLED = 0L;
    @VisibleForTesting
    public static final long DEFAULT_TOKENS_EXPIRY_SEVEN_DAYS_IN_HOURS = 168L;
    private static final Logger logger = LoggerFactory.getLogger(ImageAttachmentJwtTokenService.class);
    private final ImageAttachmentJwtSecretKeyService imageAttachmentJwtSecretKeyService;
    private final ApplicationProperties applicationProperties;
    private final Supplier<Long> currentTimeSecondsProvider;
    private static final String ABSOLUTE_REQUEST_URL_PARAMETER_NAME = "absRequestUrl";

    public ImageAttachmentJwtTokenService(ImageAttachmentJwtSecretKeyService imageAttachmentJwtSecretKeyService, ApplicationProperties applicationProperties) {
        this(imageAttachmentJwtSecretKeyService, applicationProperties, () -> System.currentTimeMillis() / 1000L);
    }

    @VisibleForTesting
    protected ImageAttachmentJwtTokenService(ImageAttachmentJwtSecretKeyService imageAttachmentJwtSecretKeyService, ApplicationProperties applicationProperties, Supplier<Long> currentTimeSecondsProvider) {
        this.imageAttachmentJwtSecretKeyService = Objects.requireNonNull(imageAttachmentJwtSecretKeyService);
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.currentTimeSecondsProvider = Objects.requireNonNull(currentTimeSecondsProvider);
    }

    private SignedJWT getVerifiedAndSignedJwtFrom(String jwtToken) throws JOSEException, ImageAttachmentJwtGenerateSecretException, ParseException, ImageAttachmentJwtSecurityException {
        MACVerifier verifier;
        SignedJWT signedJWT = SignedJWT.parse((String)jwtToken);
        boolean isVerified = signedJWT.verify((JWSVerifier)(verifier = new MACVerifier(this.imageAttachmentJwtSecretKeyService.generateOrGetSecretKey())));
        if (!isVerified) {
            throw new ImageAttachmentJwtSecurityException("Token was not verified with success");
        }
        return signedJWT;
    }

    private ImageAttachmentJwtToken signedJwtToImageAttachmentJwtToken(SignedJWT signedJWT) throws ParseException {
        JWTClaimsSet claims = signedJWT.getJWTClaimsSet();
        long expirationTimeMilliseconds = claims.getExpirationTime().getTime();
        long createdAtMillis = claims.getIssueTime().getTime();
        long currentTimeMilliseconds = this.currentTimeSecondsProvider.get() * 1000L;
        return new ImageAttachmentJwtTokenBuilder().setAbsoluteRequestUrl(claims.getStringClaim(ABSOLUTE_REQUEST_URL_PARAMETER_NAME)).setUserName(claims.getSubject()).setIsTokenValid(currentTimeMilliseconds < expirationTimeMilliseconds).setCreatedAtMillis(createdAtMillis).build();
    }

    public ImageAttachmentJwtToken parseToken(String jwtToken) throws ImageAttachmentJwtParseException, ImageAttachmentJwtGenerateSecretException, ImageAttachmentJwtSecurityException {
        try {
            SignedJWT signedJWT = this.getVerifiedAndSignedJwtFrom(jwtToken);
            return this.signedJwtToImageAttachmentJwtToken(signedJWT);
        }
        catch (ParseException e) {
            logger.warn("Could not parse jwtToken", (Throwable)e);
            throw new ImageAttachmentJwtParseException(e.getMessage());
        }
        catch (ImageAttachmentJwtGenerateSecretException e) {
            logger.warn("Could not create secret for generating jwtToken", (Throwable)e);
            throw e;
        }
        catch (ImageAttachmentJwtSecurityException e) {
            logger.warn("Could not verify jwtToken", (Throwable)e);
            throw e;
        }
        catch (JOSEException e) {
            logger.warn("Could not verify jwtToken", (Throwable)e);
            throw new ImageAttachmentJwtSecurityException(e.getMessage());
        }
        catch (Exception e) {
            throw new ImageAttachmentJwtParseException(e);
        }
    }

    public String generateToken(ImageAttachmentJwtTokenGenerateParams tokenParameters) throws ImageAttachmentJwtGenerateSecretException {
        try {
            MACSigner signer = new MACSigner(this.imageAttachmentJwtSecretKeyService.generateOrGetSecretKey());
            long currentTimeMillis = this.currentTimeSecondsProvider.get() * 1000L;
            Date currentDateTime = new Date(currentTimeMillis);
            JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject(tokenParameters.getUserName()).expirationTime(new Date(currentTimeMillis + tokenParameters.getHowManySecondsValid() * 1000L)).issueTime(currentDateTime).claim(ABSOLUTE_REQUEST_URL_PARAMETER_NAME, (Object)tokenParameters.getAbsoluteRequestUrl()).build();
            SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claimsSet);
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (Exception e) {
            throw new ImageAttachmentJwtGenerateSecretException(e);
        }
    }

    public boolean isImageAttachmentJwtTokenEnabled() {
        return this.getTokenExpiryHours() > 0L;
    }

    public Long getTokenExpiryHours() {
        String tokenExpiryHoursString = this.applicationProperties.getString("jira.security.image.attachment.jwt.tokens.expiry.hours");
        if (tokenExpiryHoursString == null) {
            return 168L;
        }
        try {
            return Long.valueOf(tokenExpiryHoursString);
        }
        catch (NumberFormatException e) {
            logger.error("Invalid value of property named %s=%s, integer expected", (Object)"jira.security.image.attachment.jwt.tokens.expiry.hours", (Object)tokenExpiryHoursString);
            return 0L;
        }
    }
}

