/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.properties;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QSecurityProperty;
import com.querydsl.core.QueryException;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityPropertiesDao {
    private static final Logger log = LoggerFactory.getLogger(SecurityPropertiesDao.class);
    private final QueryDslAccessor queryDslAccessor;

    public SecurityPropertiesDao(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    public String get(String propertyKey) {
        return this.queryDslAccessor.withNewConnection().executeQuery(dbConnection -> (String)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QSecurityProperty.SECURITY_PROPERTY.value).from((Expression)QSecurityProperty.SECURITY_PROPERTY)).where((Predicate)QSecurityProperty.SECURITY_PROPERTY.propertyKey.eq((Object)propertyKey))).fetchOne());
    }

    public String getOrCreate(String propertyKey, Supplier<String> valueCreator) {
        String value = this.get(propertyKey);
        if (value == null) {
            String newValue = valueCreator.get();
            if (newValue != null) {
                try {
                    this.queryDslAccessor.withNewConnection().executeQuery(dbConnection -> dbConnection.insert(QSecurityProperty.SECURITY_PROPERTY).set((Path)QSecurityProperty.SECURITY_PROPERTY.propertyKey, propertyKey).set((Path)QSecurityProperty.SECURITY_PROPERTY.value, newValue).execute());
                }
                catch (QueryException queryException) {
                    log.debug("failed to create value for {}", (Object)propertyKey, (Object)queryException);
                    return this.get(propertyKey);
                }
                log.info("created value for {}", (Object)propertyKey);
                return this.get(propertyKey);
            }
            return null;
        }
        return value;
    }
}

