/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.request;

import com.atlassian.jira.security.ActionInvocationCheckerBase;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.RequestMethodCheckResult;
import com.atlassian.jira.security.request.RequestMethodChecker;
import com.atlassian.jira.security.request.SupportedMethods;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.Action;
import webwork.action.CommandDriven;

public class DefaultRequestMethodChecker
extends ActionInvocationCheckerBase
implements RequestMethodChecker {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRequestMethodChecker.class);

    public RequestMethodCheckResult checkActionInvocation(@Nonnull Action action, @Nonnull String requestMethod) {
        Preconditions.checkNotNull((Object)requestMethod);
        Preconditions.checkNotNull((Object)action);
        try {
            SupportedMethods annotation = this.getAnnotationFromAction(action);
            if (annotation != null) {
                boolean result = this.checkMethodIsSupported(annotation, requestMethod);
                return () -> result;
            }
            return () -> RequestMethod.POST.matches(requestMethod);
        }
        catch (NoSuchMethodException e) {
            return () -> true;
        }
    }

    private SupportedMethods getAnnotationFromAction(Action action) throws NoSuchMethodException {
        SupportedMethods annotation = null;
        if (action instanceof CommandDriven) {
            annotation = this.getCommandAnnotation((CommandDriven)action);
        }
        if (annotation == null) {
            annotation = this.getAnnotationFromClass(action);
        }
        return annotation;
    }

    private SupportedMethods getCommandAnnotation(@Nonnull CommandDriven action) throws NoSuchMethodException {
        Method method = this.getMethod(action.getClass(), this.getMethodName(action.getCommandName()));
        if (method == null) {
            logger.warn("Didn't find method for command `{}` in class `{}`", (Object)action.getCommandName(), (Object)action.getClass().getName());
            throw new NoSuchMethodException("Method " + this.getMethodName(action.getCommandName()) + " not found for class " + action.getClass().getName());
        }
        return method.getAnnotation(SupportedMethods.class);
    }

    private SupportedMethods getAnnotationFromClass(Action action) {
        return action.getClass().getAnnotation(SupportedMethods.class);
    }

    private boolean checkMethodIsSupported(SupportedMethods annotation, String requestMethod) {
        return Arrays.stream(annotation.value()).anyMatch(supportedMethod -> supportedMethod.matches(requestMethod));
    }
}

