/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.cache.pauser.ReplicationPauserManager;
import com.atlassian.jira.config.properties.ApplicationPropertiesManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleActorsImpl;
import com.atlassian.jira.security.roles.ProjectRoleActorsZduSafeCache;
import com.atlassian.jira.security.roles.ProjectRoleAndActorStore;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.security.roles.RoleTypeMappingZduSafeCache;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.ProjectRoleActorFKChangedEvent;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class CachingProjectRoleAndActorStore
implements ProjectRoleAndActorStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingProjectRoleAndActorStore.class);
    private final ProjectRoleAndActorStore delegate;
    private final RoleActorFactory roleActorFactory;
    private final CachedReference<AllProjectRoles> projectRoles;
    private final RoleTypeMappingZduSafeCache roleTypeMappingZduSafeCache;
    @VisibleForTesting
    final ProjectRoleActorsZduSafeCache projectRoleActorsCache;

    public CachingProjectRoleAndActorStore(ProjectRoleAndActorStore delegate, RoleActorFactory roleActorFactory, CacheManager cacheManager, ReplicationPauserManager replicationPauserManager, ApplicationPropertiesManager applicationPropertiesManager) {
        this.delegate = delegate;
        this.roleActorFactory = roleActorFactory;
        this.projectRoles = cacheManager.getCachedReference(this.getClass().getName() + ".projectRoles", () -> new AllProjectRoles(this.delegate.getAllProjectRoles()));
        this.projectRoleActorsCache = new ProjectRoleActorsZduSafeCache(cacheManager, replicationPauserManager, this.getClass().getName() + ".projectRoleActors", (Cache<ProjectRoleMapping, ProjectRoleActors>)cacheManager.getCache(this.getClass().getName() + ".projectRoleActorsV2", this::loadProjectRoleActorsFromDelegate, new CacheSettingsBuilder().remote().replicateViaInvalidation().unflushable().build()));
        this.roleTypeMappingZduSafeCache = new RoleTypeMappingZduSafeCache(cacheManager, delegate, applicationPropertiesManager);
    }

    @Override
    public Collection<ProjectRole> getAllProjectRoles() {
        return ((AllProjectRoles)this.projectRoles.get()).getAll();
    }

    @Override
    public ProjectRole getProjectRole(Long id) {
        return ((AllProjectRoles)this.projectRoles.get()).get(id);
    }

    @Override
    public ProjectRole getProjectRoleByName(String name) {
        return ((AllProjectRoles)this.projectRoles.get()).getByName(name);
    }

    @Override
    public ProjectRole addProjectRole(ProjectRole projectRole) {
        try {
            ProjectRole projectRole2 = this.delegate.addProjectRole(projectRole);
            return projectRole2;
        }
        finally {
            this.projectRoles.reset();
        }
    }

    @Override
    public void updateProjectRole(ProjectRole projectRole) {
        try {
            this.delegate.updateProjectRole(projectRole);
        }
        finally {
            this.projectRoles.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteProjectRole(ProjectRole projectRole) {
        long projectRoleId = (Long)Assertions.notNull((String)"projectRole.getId()", (Object)((ProjectRole)Assertions.notNull((String)"projectRole", (Object)projectRole)).getId());
        try {
            this.getRoleActorsParametersAndTypeByProjectRoleId(projectRole.getId()).forEach(this.roleTypeMappingZduSafeCache::remove);
            this.delegate.deleteProjectRole(projectRole);
        }
        finally {
            this.projectRoles.reset();
            this.projectRoleActorsCache.removeByRoleId(projectRoleId);
        }
    }

    @Override
    public DefaultRoleActors getDefaultRoleActors(Long projectRoleId) {
        return this.getProjectRoleActors(projectRoleId, null);
    }

    @Override
    public ProjectRoleActors getProjectRoleActors(@Nonnull Long projectRoleId, Long projectId) {
        ProjectRoleActors actors = this.projectRoleActorsCache.get(ProjectRoleMapping.of(projectId, (Long)Assertions.notNull((String)"projectRoleId", (Object)projectRoleId)));
        return actors == null ? new ProjectRoleActorsImpl(projectId, projectRoleId, Collections.emptySet()) : actors;
    }

    @Override
    public void updateProjectRoleActors(ProjectRoleActors projectRoleActors) {
        if (projectRoleActors.getProjectId() == null) {
            this.updateDefaultRoleActors((DefaultRoleActors)projectRoleActors);
            return;
        }
        this.getRoleActorsParametersAndTypeByProjectId(projectRoleActors.getProjectId()).forEach(this.roleTypeMappingZduSafeCache::remove);
        this.delegate.updateProjectRoleActors(projectRoleActors);
        this.projectRoleActorsCache.remove(ProjectRoleMapping.of(projectRoleActors));
    }

    @Override
    public void updateDefaultRoleActors(DefaultRoleActors defaultRoleActors) {
        this.getRoleActorsParametersAndTypeByProjectRoleId(defaultRoleActors.getProjectRoleId()).forEach(this.roleTypeMappingZduSafeCache::remove);
        this.delegate.updateDefaultRoleActors(defaultRoleActors);
        this.projectRoleActorsCache.remove(ProjectRoleMapping.of(defaultRoleActors));
    }

    @Override
    public void applyDefaultsRolesToProject(Project project) {
        this.getRoleActorsParametersAndTypeByProjectId(project.getId()).forEach(this.roleTypeMappingZduSafeCache::remove);
        this.delegate.applyDefaultsRolesToProject(project);
        this.projectRoleActorsCache.removeByProjectId(project.getId());
    }

    @Override
    public void removeAllRoleActorsByKeyAndType(String key, String type) {
        Collection<Long> projectsToInvalidate = this.delegate.getProjectIdsContainingRoleActorByKeyAndType(key, type);
        this.delegate.removeAllRoleActorsByKeyAndType(key, type);
        projectsToInvalidate.forEach(this.projectRoleActorsCache::removeByProjectId);
        this.roleTypeMappingZduSafeCache.remove(ProjectRoleAndActorStore.RoleTypeMapping.of(key, type));
    }

    @Override
    public void removeAllRoleActorsByProject(Project project) {
        this.delegate.getRoleActorsParametersAndTypeByProjectId(project.getId()).forEach(this.roleTypeMappingZduSafeCache::remove);
        this.delegate.removeAllRoleActorsByProject(project);
        this.projectRoleActorsCache.removeByProjectId(project.getId());
    }

    public void clearCacheForProject(Project project) {
        this.delegate.getRoleActorsParametersAndTypeByProjectId(project.getId()).forEach(this.roleTypeMappingZduSafeCache::remove);
        this.projectRoleActorsCache.removeByProjectId(project.getId());
    }

    @Override
    public Collection<Long> getProjectIdsContainingRoleActorByKeyAndType(String key, String type) {
        return this.delegate.getProjectIdsContainingRoleActorByKeyAndType(key, type);
    }

    @Override
    public List<Long> roleActorOfTypeExistsForProjects(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String projectRoleParameter) {
        return this.delegate.roleActorOfTypeExistsForProjects(projectsToLimitBy, projectRole, projectRoleType, projectRoleParameter);
    }

    @Override
    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String userKey) {
        return this.delegate.getProjectIdsForUserInGroupsBecauseOfRole(projectsToLimitBy, projectRole, projectRoleType, userKey);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCaches();
    }

    @EventListener
    public void onProjectRoleActorFKChanged(ProjectRoleActorFKChangedEvent event) {
        LOGGER.info("ProjectRoleFKChangedEvent was received, flushing ProjectRoleActorStore caches.");
        this.clearCaches();
    }

    public void clearCaches() {
        this.projectRoles.reset();
        this.projectRoleActorsCache.removeAll();
        this.roleTypeMappingZduSafeCache.removeAll();
    }

    private CachedRoleActors toCachedRoleActor(@Nonnull DefaultRoleActors defaultRoleActors) {
        Set optimizedRoleActors = this.roleActorFactory.optimizeRoleActorSet(defaultRoleActors.getRoleActors());
        return new CachedRoleActors(defaultRoleActors, optimizedRoleActors);
    }

    @Override
    public boolean isGroupUsed(@Nonnull String group) {
        return this.delegate.isGroupUsed(group);
    }

    @Override
    public ProjectRoleManager.ProjectIdToProjectRoleIdsMap getProjectIdToRoleIds(@Nonnull String roleTypeParameter, @Nonnull String roleType) {
        return this.roleTypeMappingZduSafeCache.get(ProjectRoleAndActorStore.RoleTypeMapping.of(roleTypeParameter, roleType));
    }

    @Override
    public List<ProjectRoleAndActorStore.RoleTypeMapping> getRoleActorsParametersAndTypeByProjectId(@Nonnull Long projectId) {
        return this.delegate.getRoleActorsParametersAndTypeByProjectId(projectId);
    }

    @Override
    public List<ProjectRoleAndActorStore.RoleTypeMapping> getRoleActorsParametersAndTypeByProjectRoleId(@Nonnull Long projectRoleId) {
        return this.delegate.getRoleActorsParametersAndTypeByProjectRoleId(projectRoleId);
    }

    @Nonnull
    private ProjectRoleActors loadProjectRoleActorsFromDelegate(@Nonnull ProjectRoleMapping key) {
        ProjectRoleActors projectRoleActors = this.delegate.getProjectRoleActors(key.getRoleId(), key.getProjectId());
        if (projectRoleActors == null) {
            projectRoleActors = new ProjectRoleActorsImpl(key.getProjectId(), (Long)key.getRoleId(), Collections.emptySet());
        }
        return this.toCachedRoleActor((DefaultRoleActors)projectRoleActors);
    }

    @Nonnull
    private ProjectRoleManager.ProjectIdToProjectRoleIdsMap loadProjectIdToProjectRoleIdsFromDelegate(@Nonnull ProjectRoleAndActorStore.RoleTypeMapping key) {
        return this.delegate.getProjectIdToRoleIds(key.getRoleTypeParameter(), key.getRoleType());
    }

    @Immutable
    static class ProjectRoleMapping
    implements Serializable {
        private static final long serialVersionUID = -1487266794219769058L;
        @Nullable
        private final Long projectId;
        private final long roleId;

        private ProjectRoleMapping(@Nullable Long projectId, long roleId) {
            this.projectId = projectId;
            this.roleId = roleId;
        }

        static ProjectRoleMapping of(@Nullable Long projectId, long roleId) {
            return new ProjectRoleMapping(projectId, roleId);
        }

        static ProjectRoleMapping of(ProjectRoleActors projectRoleActors) {
            return new ProjectRoleMapping(projectRoleActors.getProjectId(), projectRoleActors.getProjectRoleId());
        }

        static ProjectRoleMapping of(DefaultRoleActors projectRoleActors) {
            return new ProjectRoleMapping(null, projectRoleActors.getProjectRoleId());
        }

        @Nullable
        public Long getProjectId() {
            return this.projectId;
        }

        public long getRoleId() {
            return this.roleId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectRoleMapping that = (ProjectRoleMapping)o;
            return this.roleId == that.roleId && Objects.equals(this.projectId, that.projectId);
        }

        public int hashCode() {
            return Objects.hash(this.projectId, this.roleId);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("projectId", (Object)this.projectId).append("roleId", this.roleId).toString();
        }
    }

    static class CachedRoleActors
    implements ProjectRoleActors {
        private final DefaultRoleActors delegate;
        private final Set<RoleActor> optimizedProjectRoleSet;

        CachedRoleActors(DefaultRoleActors delegate, Set<RoleActor> optimizedProjectRoleSet) {
            this.delegate = delegate;
            this.optimizedProjectRoleSet = ImmutableSet.copyOf(optimizedProjectRoleSet);
        }

        public boolean contains(ApplicationUser user) {
            for (RoleActor o : this.optimizedProjectRoleSet) {
                if (!o.contains(user)) continue;
                return true;
            }
            return false;
        }

        public Long getProjectId() {
            return this.delegate instanceof ProjectRoleActors ? ((ProjectRoleActors)this.delegate).getProjectId() : null;
        }

        public Set<ApplicationUser> getUsers() {
            return this.delegate.getUsers();
        }

        public Set<ApplicationUser> getApplicationUsers() {
            return this.delegate.getApplicationUsers();
        }

        public Set<RoleActor> getRoleActors() {
            return this.delegate.getRoleActors();
        }

        public Long getProjectRoleId() {
            return this.delegate.getProjectRoleId();
        }

        public Set<RoleActor> getRoleActorsByType(String type) {
            return this.delegate.getRoleActorsByType(type);
        }

        public DefaultRoleActors addRoleActors(Collection<? extends RoleActor> roleActors) {
            return this.delegate.addRoleActors(roleActors);
        }

        public DefaultRoleActors addRoleActor(RoleActor roleActor) {
            return this.delegate.addRoleActor(roleActor);
        }

        public DefaultRoleActors removeRoleActor(RoleActor roleActor) {
            return this.delegate.removeRoleActor(roleActor);
        }

        public DefaultRoleActors removeRoleActors(Collection<? extends RoleActor> roleActors) {
            return this.delegate.removeRoleActors(roleActors);
        }

        public String toString() {
            return "CachedRoleActors[delegate=" + this.delegate + ",optimizedProjectRoleSet=" + this.optimizedProjectRoleSet + ']';
        }
    }

    static class AllProjectRoles {
        private final List<ProjectRole> projectRoles;
        private final Map<Long, ProjectRole> projectRolesById;
        private final Map<String, ProjectRole> projectRolesByName;

        AllProjectRoles(Collection<ProjectRole> projectRoles) {
            ImmutableMap.Builder byId = ImmutableMap.builder();
            ImmutableMap.Builder byName = ImmutableMap.builder();
            for (ProjectRole projectRole : projectRoles) {
                byId.put((Object)projectRole.getId(), (Object)projectRole);
                byName.put((Object)projectRole.getName(), (Object)projectRole);
            }
            this.projectRoles = ImmutableList.copyOf(projectRoles);
            this.projectRolesById = byId.build();
            this.projectRolesByName = byName.build();
        }

        Collection<ProjectRole> getAll() {
            return this.projectRoles;
        }

        ProjectRole get(Long id) {
            return this.projectRolesById.get(id);
        }

        ProjectRole getByName(String name) {
            return this.projectRolesByName.get(name);
        }
    }
}

