/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.SecurityIndexingUtils;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.type.AbstractSecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.util.BytesRef;

public abstract class AbstractIssueFieldSecurityType
extends AbstractSecurityType {
    @Override
    public boolean isTopLevelProjectPermission() {
        return false;
    }

    protected abstract String getFieldName(String var1);

    @Override
    public Set<BytesRef> getPermissionFieldContents(ApplicationUser searcher, @Nonnull Project project, String parameter) {
        PermissionSchemeManager permissionSchemeManager = ComponentAccessor.getPermissionSchemeManager();
        Long schemeId = permissionSchemeManager.getSchemeIdFor(project);
        if (schemeId == null) {
            throw new IllegalStateException("No permission scheme associated with project " + project.getKey());
        }
        if (permissionSchemeManager.getPermissionSchemeEntries(schemeId.longValue(), ProjectPermissions.BROWSE_PROJECTS, this.getType()).size() > 0) {
            return this.getPermissionFieldContentsForProject(project, searcher, this.getFieldName(parameter));
        }
        return ImmutableSet.of();
    }

    @Override
    public boolean isTopLevelIssueSecurityPermission() {
        return false;
    }

    @Override
    public Set<BytesRef> getPermissionFieldContents(ApplicationUser searcher, Project project, IssueSecurityLevel securityLevel, String parameter) {
        return this.getPermissionFieldContentsForSecurityLevel(securityLevel, searcher, this.getFieldName(parameter));
    }

    @Nullable
    protected Set<BytesRef> getPermissionFieldContentsForProject(@Nonnull Project project, @Nullable ApplicationUser searcher, @Nonnull String fieldName) {
        if (searcher != null) {
            return ImmutableSet.of((Object)SecurityIndexingUtils.generateProjectPermissionFieldContents((Long)project.getId(), (String)fieldName, (String)searcher.getKey()));
        }
        return ImmutableSet.of();
    }

    @Nullable
    protected Set<BytesRef> getPermissionFieldContentsForSecurityLevel(@Nonnull IssueSecurityLevel issueSecurity, @Nullable ApplicationUser searcher, @Nonnull String fieldName) {
        if (searcher != null) {
            return ImmutableSet.of((Object)SecurityIndexingUtils.generateIssueLevelPermissionContents((Long)issueSecurity.getId(), (String)fieldName, (String)searcher.getKey()));
        }
        return ImmutableSet.of();
    }

    @Override
    public boolean hasPermission(Issue issue, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(Project project, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter, ApplicationUser user, boolean issueCreation) {
        if (user == null || issue == null) {
            return false;
        }
        return this.hasIssuePermission(user, issueCreation, issue, parameter);
    }

    @Override
    public boolean hasPermission(Project project, String parameter, ApplicationUser user, boolean issueCreation) {
        if (user == null || project == null) {
            return false;
        }
        return this.hasProjectPermission(user, issueCreation, project);
    }

    protected abstract boolean hasIssuePermission(ApplicationUser var1, boolean var2, Issue var3, String var4);

    protected abstract boolean hasProjectPermission(ApplicationUser var1, boolean var2, Project var3);
}

