/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.util;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.GroupSelectorField;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupSelectorUtils {
    private static final Logger log = LoggerFactory.getLogger(GroupSelectorUtils.class);
    private final FieldManager fieldManager;
    private final UserUtil userUtil;
    private final GroupManager groupManager;

    public GroupSelectorUtils(FieldManager fieldManager, UserUtil userUtil, GroupManager groupManager) {
        this.fieldManager = fieldManager;
        this.userUtil = userUtil;
        this.groupManager = groupManager;
    }

    public Set<ApplicationUser> getUsers(Issue issue, String customFieldId) {
        try (Ticker ignored = Timers.start((String)"GroupCF.getUsers");){
            if (issue == null) {
                ImmutableSet immutableSet = ImmutableSet.of();
                return immutableSet;
            }
            CustomField field = this.fieldManager.getCustomField(customFieldId);
            if (field == null) {
                throw new IllegalArgumentException("Group Selector permission configured with custom field " + customFieldId + ", but this field does not exist");
            }
            if (!(field.getCustomFieldType() instanceof GroupSelectorField)) {
                throw new IllegalArgumentException("Group Selector permission configured with field " + customFieldId + ", but this is not a type that can select groups");
            }
            Set<ApplicationUser> set = this.getUsers(issue, field);
            return set;
        }
    }

    private Set<ApplicationUser> getUsers(Issue issue, CustomField field) {
        Object groupCFValue = field.getValue(issue);
        Set<Group> groups = this.getGroups(groupCFValue);
        if (log.isDebugEnabled()) {
            if (groupCFValue == null) {
                log.debug("Issue " + issue + " does not have a value for field " + field);
            } else if (groups.isEmpty()) {
                log.debug("No groups found for group selector value '" + groupCFValue + "' on issue " + issue + ". Perhaps that group no longer exists?");
            } else {
                log.debug("GroupCF returned users from groups " + Arrays.toString(groups.toArray()));
            }
        }
        return Sets.newHashSet((Iterable)this.userUtil.getAllUsersInGroups(groups));
    }

    public Set<ApplicationUser> getUsers(Object groupCustomFieldRawValue) {
        if (groupCustomFieldRawValue == null) {
            return ImmutableSet.of();
        }
        return Sets.newHashSet((Iterable)this.userUtil.getAllUsersInGroups(this.getGroups(groupCustomFieldRawValue)));
    }

    public List<Field> getCustomFieldsSpecifyingGroups() {
        Set fieldSet;
        try {
            fieldSet = this.fieldManager.getAllAvailableNavigableFields();
        }
        catch (FieldException e) {
            return Collections.emptyList();
        }
        ArrayList<Field> fields = new ArrayList<Field>(fieldSet.size() / 4);
        for (Field field : fieldSet) {
            CustomField customField;
            if (!this.fieldManager.isCustomField(field) || !((customField = (CustomField)field).getCustomFieldType() instanceof GroupSelectorField)) continue;
            fields.add(field);
        }
        return fields;
    }

    public boolean isUserInCustomFieldGroup(Issue issue, CustomField field, ApplicationUser user) {
        Object cfValue = issue.getCustomFieldValue(field);
        Set<Group> groups = this.getGroups(cfValue);
        for (Group group : groups) {
            if (!this.groupManager.isUserInGroup(user, group)) continue;
            return true;
        }
        return false;
    }

    private Set<Group> getGroups(Object cfValue) {
        if (cfValue == null) {
            return ImmutableSet.of();
        }
        if (cfValue instanceof Group) {
            return ImmutableSet.of((Object)((Group)cfValue));
        }
        if (cfValue instanceof String) {
            return this.getGroups((String)cfValue);
        }
        if (cfValue instanceof Option) {
            return this.getGroups(((Option)cfValue).getValue());
        }
        if (cfValue instanceof Collection) {
            Collection groupList = (Collection)cfValue;
            HashSet<Group> groups = new HashSet<Group>(groupList.size());
            for (Object groupValue : groupList) {
                groups.addAll(this.getGroups(groupValue));
            }
            return groups;
        }
        log.error("Object '" + cfValue + "' is of type " + cfValue.getClass().getName() + " which cannot be converted to a Group. Needs to be a Group object or a String representing group name.");
        return ImmutableSet.of();
    }

    private Set<Group> getGroups(String groupStr) {
        Group group = this.groupManager.getGroup(groupStr);
        if (group != null) {
            return ImmutableSet.of((Object)group);
        }
        return ImmutableSet.of();
    }
}

