/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servermetrics;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ServletSafeComponentReference<T>
implements Supplier<Optional<T>> {
    private final Class<T> componentClass;

    public ServletSafeComponentReference(@Nonnull Class<T> componentClass) {
        this.componentClass = (Class)Assertions.notNull((String)"componentClass", componentClass);
    }

    public Optional<T> get() {
        return ComponentAccessor.getComponentSafely(this.componentClass);
    }

    public static <X> ServletSafeComponentReference<X> build(Class<X> componentClass) {
        return new ServletSafeComponentReference<X>(componentClass);
    }
}

