/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.analytics.start;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.service.services.analytics.JiraAnalyticTask;
import com.atlassian.jira.util.collect.MapBuilder;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class Ipv6StatusAnalyticTask
implements JiraAnalyticTask {
    private static final String IPv6_LINK_LOCAL = "fe80";
    private static final String IPv6_SEPARATOR = ":";
    private ApplicationProperties applicationProperties;

    @Override
    public void init() {
        this.applicationProperties = ComponentAccessor.getApplicationProperties();
    }

    @Override
    public Map<String, Object> getAnalytics() {
        MapBuilder builder = MapBuilder.newBuilder();
        builder.add((Object)"network.ipv4", (Object)this.hasIpv4Interfaces());
        builder.add((Object)"network.ipv6", (Object)this.hasIpv6Interfaces());
        ResolvedUrl resolvedUrl = this.resolveUrl(this.applicationProperties.getString("jira.baseurl"));
        builder.add((Object)"jira.baseurl.ipv4", (Object)resolvedUrl.ipv4);
        builder.add((Object)"jira.baseurl.ipv6", (Object)resolvedUrl.ipv6);
        return builder.toMap();
    }

    private ResolvedUrl resolveUrl(String url) {
        ResolvedUrl result = new ResolvedUrl();
        try {
            String hostname = new URL(url).getHost();
            InetAddress[] addresses = InetAddress.getAllByName(hostname);
            result.ipv4 = Arrays.stream(addresses).anyMatch(ia -> ia instanceof Inet4Address);
            result.ipv6 = Arrays.stream(addresses).anyMatch(ia -> ia instanceof Inet6Address);
        }
        catch (MalformedURLException | UnknownHostException iOException) {
            // empty catch block
        }
        return result;
    }

    private boolean hasIpv6Interfaces() {
        try {
            return Collections.list(NetworkInterface.getNetworkInterfaces()).stream().anyMatch(ni -> ni.getInterfaceAddresses().stream().filter(ia -> !ia.getAddress().isLoopbackAddress()).filter(ia -> !ia.getAddress().getHostAddress().toLowerCase().startsWith(IPv6_LINK_LOCAL)).anyMatch(ia -> ia.getAddress().getHostAddress().contains(IPv6_SEPARATOR)));
        }
        catch (SocketException ignored) {
            return false;
        }
    }

    private boolean hasIpv4Interfaces() {
        try {
            return Collections.list(NetworkInterface.getNetworkInterfaces()).stream().anyMatch(ni -> ni.getInterfaceAddresses().stream().filter(ia -> !ia.getAddress().isLoopbackAddress()).anyMatch(ia -> !ia.getAddress().getHostAddress().contains(IPv6_SEPARATOR)));
        }
        catch (SocketException ignored) {
            return false;
        }
    }

    @Override
    public boolean isReportingDataShape() {
        return false;
    }

    private class ResolvedUrl {
        private boolean ipv4;
        private boolean ipv6;

        private ResolvedUrl() {
        }
    }
}

