/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.mail;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.service.AbstractService;
import com.atlassian.jira.service.services.LocalService;
import com.atlassian.mail.queue.MailQueue;
import com.opensymphony.module.propertyset.PropertySet;

public class MailQueueService
extends AbstractService
implements LocalService {
    public void run() {
        MailQueue queue = (MailQueue)ComponentAccessor.getComponent(MailQueue.class);
        this.log.debug((Object)"Attempting to run mail queue service");
        if (queue.size() < 1) {
            return;
        }
        if (!queue.isSending()) {
            this.log.debug((Object)"Starting to send items in the mail queue.");
            queue.sendBuffer();
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Skipping mail queue service run, service seems to be running already.");
            String detail = String.format("Queue Information: \n\n Number of elements: %d\nNumber of elements in error: %d\nItem being sent: %s", queue.size(), queue.errorSize(), queue.getItemBeingSent());
            this.log.debug((Object)detail);
        }
    }

    public void init(PropertySet props) throws ObjectConfigurationException {
        this.log.debug((Object)"initialising MailQueueService");
    }

    public boolean isUnique() {
        return true;
    }

    public boolean isInternal() {
        return true;
    }

    public void destroy() {
        this.log.debug((Object)"destroying MailQueueService, running one last time to ensure we send the queue");
        this.run();
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("MAILQUEUESERVICE", "services/com/atlassian/jira/service/services/mail/mailservice.xml", null);
    }
}

