/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.servlet.ApplicationStateResolver;
import com.atlassian.jira.servlet.ApplicationStateResolverImpl;
import com.atlassian.jira.util.system.status.ApplicationState;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApplicationStatusServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationStateAndHttpStatus state = this.getApplicationState();
        resp.setStatus(state.httpStatus);
        resp.setContentType("application/json");
        resp.getWriter().append("{\"state\":\"").append(state.applicationState.name()).append("\"}");
    }

    private ApplicationStateAndHttpStatus getApplicationState() {
        ApplicationState state = this.getApplicationStateResolver().getApplicationState();
        switch (state) {
            case MAINTENANCE: {
                return new ApplicationStateAndHttpStatus(ApplicationState.MAINTENANCE, 503);
            }
            case ERROR: {
                return new ApplicationStateAndHttpStatus(ApplicationState.ERROR, 500);
            }
        }
        return new ApplicationStateAndHttpStatus(state, 200);
    }

    @VisibleForTesting
    ApplicationStateResolver getApplicationStateResolver() {
        return ComponentAccessor.getComponentSafely(ApplicationStateResolver.class).orElseGet(ApplicationStateResolverImpl::new);
    }

    private static class ApplicationStateAndHttpStatus {
        final ApplicationState applicationState;
        final int httpStatus;

        public ApplicationStateAndHttpStatus(ApplicationState applicationState, int httpStatus) {
            this.applicationState = applicationState;
            this.httpStatus = httpStatus;
        }
    }
}

