/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.jira.servlet.Language;
import com.google.common.base.Preconditions;
import com.octo.captcha.component.word.wordgenerator.WordGenerator;
import java.util.Locale;

final class CensoringWordGenerator
implements WordGenerator {
    private final WordGenerator censoredWordGenerator;
    private final int maxRejections;

    CensoringWordGenerator(WordGenerator censoredWordGenerator, int maxRejections) {
        this.censoredWordGenerator = (WordGenerator)Preconditions.checkNotNull((Object)censoredWordGenerator);
        this.maxRejections = maxRejections;
    }

    public String getWord(Integer length) {
        Language language = Language.forDefaultLocale();
        String word = this.censoredWordGenerator.getWord(length);
        for (int rejections = 0; language.isOffensive(word) && rejections < this.maxRejections; ++rejections) {
            word = this.censoredWordGenerator.getWord(length);
        }
        return word;
    }

    public String getWord(Integer length, Locale locale) {
        Language language = Language.forLocale(locale);
        String word = this.censoredWordGenerator.getWord(length, locale);
        for (int rejections = 0; language.isOffensive(word) && rejections < this.maxRejections; ++rejections) {
            word = this.censoredWordGenerator.getWord(length, locale);
        }
        return word;
    }
}

