/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.parameters.lucene.sort.MappedSortComparator;
import com.atlassian.jira.issue.statistics.AssigneeStatisticsMapper;
import com.atlassian.jira.sharing.SharedEntityColumn;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.concurrent.Immutable;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;

@Immutable
public class SharedEntityColumnDefinition {
    public static final SharedEntityColumnDefinition ID = new SharedEntityColumnDefinition("id", SortField.Type.INT);
    public static final SharedEntityColumnDefinition NAME = new SharedEntityColumnDefinition("name", "nameSort", "nameCaseless", SortField.Type.STRING);
    public static final SharedEntityColumnDefinition DESCRIPTION = new SharedEntityColumnDefinition("description", "descriptionSort", SortField.Type.STRING);
    public static final SharedEntityColumnDefinition OWNER = new SharedEntityColumnDefinition("owner", new SortComparatorFactory(){

        @Override
        public FieldComparatorSource getSortComparator() {
            return new MappedSortComparator((LuceneFieldSorter)ComponentAccessor.getComponentOfType(AssigneeStatisticsMapper.class));
        }
    });
    public static final SharedEntityColumnDefinition FAVOURITE_COUNT = new SharedEntityColumnDefinition("favouriteCount", SortField.Type.INT);
    public static final SharedEntityColumnDefinition IS_SHARED = new SharedEntityColumnDefinition("isShared", SortField.Type.STRING);
    private final String name;
    private final String sortColumn;
    private final String caseInsensitiveColumn;
    private final SortField.Type sortType;
    private final SortComparatorFactory sortComparatorFactory;

    private SharedEntityColumnDefinition(String sortColumn, SortField.Type sortType) {
        this(sortColumn, sortColumn, sortType);
    }

    private SharedEntityColumnDefinition(String name, String sortColumn, SortField.Type sortType) {
        Assertions.notNull((String)"sortColumn", (Object)sortColumn);
        this.name = name;
        this.sortColumn = sortColumn;
        this.caseInsensitiveColumn = null;
        this.sortType = sortType;
        this.sortComparatorFactory = null;
    }

    private SharedEntityColumnDefinition(String name, String sortColumn, String caseInsensitiveColumn, SortField.Type sortType) {
        Assertions.notNull((String)"sortColumn", (Object)sortColumn);
        this.name = name;
        this.sortColumn = sortColumn;
        this.sortType = sortType;
        this.caseInsensitiveColumn = caseInsensitiveColumn;
        this.sortComparatorFactory = null;
    }

    private SharedEntityColumnDefinition(String name, SortComparatorFactory sortComparatorFactory) {
        Assertions.notNull((String)"sortColumn", (Object)name);
        this.name = name;
        this.sortComparatorFactory = sortComparatorFactory;
        this.caseInsensitiveColumn = null;
        this.sortColumn = name;
        this.sortType = SortField.Type.CUSTOM;
    }

    public String getName() {
        return this.name;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public SortField.Type getSortType() {
        return this.sortType;
    }

    public String getCaseInsensitiveColumn() {
        return this.caseInsensitiveColumn;
    }

    public boolean isCustomSort() {
        return this.sortComparatorFactory != null;
    }

    public FieldComparatorSource createSortComparator() {
        return this.sortComparatorFactory.getSortComparator();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedEntityColumnDefinition sortOrder = (SharedEntityColumnDefinition)o;
        return !(this.sortColumn != null ? !this.sortColumn.equals(sortOrder.sortColumn) : sortOrder.sortColumn != null);
    }

    public int hashCode() {
        return this.sortColumn != null ? this.sortColumn.hashCode() : 0;
    }

    public static SharedEntityColumnDefinition definitionFor(SharedEntityColumn column) {
        switch (column) {
            case ID: {
                return ID;
            }
            case NAME: {
                return NAME;
            }
            case DESCRIPTION: {
                return DESCRIPTION;
            }
            case OWNER: {
                return OWNER;
            }
            case FAVOURITE_COUNT: {
                return FAVOURITE_COUNT;
            }
        }
        throw new IllegalArgumentException("Unknown SharedEntityColumn " + column);
    }

    static interface SortComparatorFactory {
        public FieldComparatorSource getSortComparator();
    }
}

