/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.search.GroupShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.GroupSharePermission;
import com.atlassian.jira.sharing.type.ShareQueryFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class GroupShareQueryFactory
implements ShareQueryFactory<GroupShareTypeSearchParameter> {
    private final GroupManager groupManager;

    public GroupShareQueryFactory(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public Query getQuery(ShareTypeSearchParameter searchParameter, ApplicationUser user) {
        return this.getQuery(searchParameter);
    }

    public Query getQuery(ShareTypeSearchParameter searchParameter) {
        return new TermQuery(new Term("shareTypeGroup", ((GroupShareTypeSearchParameter)searchParameter).getGroupName()));
    }

    public Term[] getTerms(ApplicationUser user) {
        if (user == null) {
            return new Term[0];
        }
        Collection groups = this.groupManager.getGroupNamesForUser(user);
        ArrayList result = Lists.newArrayListWithCapacity((int)groups.size());
        for (String element : groups) {
            result.add(new Term("shareTypeGroup", element));
        }
        return result.toArray(new Term[result.size()]);
    }

    public Field getField(SharedEntity entity, SharePermission permission) {
        return new StringField("shareTypeGroup", new GroupSharePermission(permission).getGroupName(), Field.Store.YES);
    }

    private static final class Name {
        static final String FIELD = "shareTypeGroup";

        private Name() {
        }
    }
}

