/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.util.EncodingConfiguration;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.GroupShareType;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.sharing.type.VelocityShareTypeRenderer;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.text.StringEscapeUtils;

public class GroupShareTypeRenderer
extends VelocityShareTypeRenderer {
    private static final String GROUPS_KEY = "groups";
    private final GroupManager groupManager;
    private final FeatureManager featureManager;
    private final GlobalPermissionManager globalPermissionManager;

    public GroupShareTypeRenderer(EncodingConfiguration encoding, VelocityTemplatingEngine templatingEngine, GroupManager groupManager, GlobalPermissionManager globalPermissionManager, FeatureManager featureManager) {
        super(encoding, templatingEngine, globalPermissionManager);
        this.groupManager = groupManager;
        this.globalPermissionManager = globalPermissionManager;
        this.featureManager = featureManager;
    }

    public String renderPermission(SharePermission permission, JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        Assertions.equals((String)"permission-type", (Object)GroupShareType.TYPE, (Object)permission.getType());
        String groupName = TextUtils.htmlEncode((String)permission.getParam1());
        return authenticationContext.getI18nHelper().getText("common.sharing.shared.display.group", "<b>", "</b>", groupName, GroupShareTypeRenderer.getRightsDescription(permission.getRights(), authenticationContext));
    }

    public String getSimpleDescription(SharePermission permission, JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        Assertions.equals((String)"permission-type", (Object)GroupShareType.TYPE, (Object)permission.getType());
        String groupName = TextUtils.htmlEncode((String)permission.getParam1());
        return authenticationContext.getI18nHelper().getText("common.sharing.shared.display.group.desc", groupName, GroupShareTypeRenderer.getRightsDescription(permission.getRights(), authenticationContext));
    }

    public String getShareTypeEditor(JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        if (this.canShareWithAllGroups(authenticationContext.getLoggedInUser())) {
            return this.renderVelocity("share-type-group-picker-selector.vm", new HashMap<String, Object>(), authenticationContext);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> groups = new ArrayList<String>(this.getGroupsForUser(authenticationContext.getLoggedInUser()));
        Collections.sort(groups);
        params.put(GROUPS_KEY, groups);
        return this.renderVelocity("share-type-group-dropdown-selector.vm", params, authenticationContext);
    }

    public boolean isAddButtonNeeded(JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        return !this.getGroupsForUser(authenticationContext.getLoggedInUser()).isEmpty();
    }

    public String getShareTypeLabel(JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        return authenticationContext.getI18nHelper().getText("common.sharing.shared.description.group");
    }

    public Map<String, String> getTranslatedTemplates(JiraAuthenticationContext authenticationContext, SharedEntity.TypeDescriptor<? extends SharedEntity> type, ShareTypeRenderer.RenderMode mode) {
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        Assertions.notNull((String)"type", type);
        Assertions.notNull((String)"mode", (Object)mode);
        HashMap<String, String> templates = new HashMap<String, String>();
        if (mode == ShareTypeRenderer.RenderMode.EDIT) {
            templates.put("share_group_display", StringEscapeUtils.escapeEcmaScript((String)authenticationContext.getI18nHelper().getText("common.sharing.shared.template.group", "<b>", "</b>")));
            templates.put("share_group_description", StringEscapeUtils.escapeEcmaScript((String)authenticationContext.getI18nHelper().getText("common.sharing.shared.template.group.desc")));
        } else if (mode == ShareTypeRenderer.RenderMode.SEARCH) {
            templates.put("share_group_description", StringEscapeUtils.escapeEcmaScript((String)authenticationContext.getI18nHelper().getText("common.sharing.search.template.group.desc." + type.getName())));
        }
        return Collections.unmodifiableMap(templates);
    }

    List<String> getGroupsForUser(ApplicationUser user) {
        if (user == null) {
            return Collections.emptyList();
        }
        if (this.canShareWithAllGroups(user)) {
            return new ArrayList<String>(this.groupManager.getAllGroupNames());
        }
        Collection groupNames = this.groupManager.getGroupNamesForUser(user);
        return new ArrayList<String>(groupNames);
    }

    private boolean canShareWithAllGroups(@Nullable ApplicationUser user) {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES) && this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }
}

