/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.util.EncodingConfiguration;
import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.InternalProjectPermissionHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleComparator;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ProjectShareType;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.sharing.type.VelocityShareTypeRenderer;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.json.JSONArray;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;
import webwork.util.TextUtil;

public class ProjectShareTypeRenderer
extends VelocityShareTypeRenderer {
    private static final String PROJECTS_KEY = "projects";
    private static final String ROLES_KEY = "roles";
    private static final String ROLES_MAP = "rolesMap";
    private static final String BR_TAG = "<br/>";
    private final ProjectManager projectManager;
    private final ProjectRoleManager projectRoleManager;
    private final PermissionManager permissionManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final FeatureManager featureManager;
    private final InternalProjectPermissionHelper projectPermissionHelper;

    public ProjectShareTypeRenderer(EncodingConfiguration encoding, VelocityTemplatingEngine templatingEngine, ProjectManager projectManager, ProjectRoleManager projectRoleManager, PermissionManager permissionManager, GlobalPermissionManager globalPermissionManager, FeatureManager featureManager, InternalProjectPermissionHelper projectPermissionHelper) {
        super(encoding, templatingEngine, globalPermissionManager);
        this.projectManager = (ProjectManager)Assertions.notNull((Object)projectManager);
        this.projectRoleManager = (ProjectRoleManager)Assertions.notNull((Object)projectRoleManager);
        this.permissionManager = (PermissionManager)Assertions.notNull((Object)permissionManager);
        this.globalPermissionManager = (GlobalPermissionManager)Assertions.notNull((Object)globalPermissionManager);
        this.featureManager = (FeatureManager)Assertions.notNull((Object)featureManager);
        this.projectPermissionHelper = (InternalProjectPermissionHelper)Assertions.notNull((Object)projectPermissionHelper);
    }

    public String renderPermission(SharePermission permission, JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        Assertions.equals((String)"permission-type", (Object)ProjectShareType.TYPE, (Object)permission.getType());
        ApplicationUser loggedInUser = authenticationContext.getLoggedInUser();
        String projectName = this.getProject(permission.getParam1(), authenticationContext.getI18nHelper(), loggedInUser);
        if (permission.getParam2() == null) {
            return authenticationContext.getI18nHelper().getText("common.sharing.shared.display.project", "<b>", "</b>", projectName, ProjectShareTypeRenderer.getRightsDescription(permission.getRights(), authenticationContext));
        }
        String roleName = this.getRole(permission, authenticationContext);
        return authenticationContext.getI18nHelper().getText("common.sharing.shared.display.project.role", "<b>", "</b>", projectName, "<br/><b>", "</b>", roleName, ProjectShareTypeRenderer.getRightsDescription(permission.getRights(), authenticationContext));
    }

    public String getSimpleDescription(SharePermission permission, JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        Assertions.equals((String)"permission-type", (Object)ProjectShareType.TYPE, (Object)permission.getType());
        ApplicationUser loggedInUser = authenticationContext.getLoggedInUser();
        String projectName = this.getProject(permission.getParam1(), authenticationContext.getI18nHelper(), loggedInUser);
        String rights = ProjectShareTypeRenderer.getRightsDescription(permission.getRights(), authenticationContext);
        if (permission.getParam2() == null) {
            return authenticationContext.getI18nHelper().getText("common.sharing.shared.display.project.desc", projectName, rights);
        }
        String roleName = this.getRole(permission, authenticationContext);
        return authenticationContext.getI18nHelper().getText("common.sharing.shared.display.project.role.desc", roleName, projectName, rights);
    }

    public Map<String, String> getTranslatedTemplates(JiraAuthenticationContext authenticationContext, SharedEntity.TypeDescriptor<? extends SharedEntity> type, ShareTypeRenderer.RenderMode mode) {
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        Assertions.notNull((String)"type", type);
        Assertions.notNull((String)"mode", (Object)mode);
        HashMap<String, String> templates = new HashMap<String, String>();
        templates.put("share_invalid_project", StringEscapeUtils.escapeEcmaScript((String)authenticationContext.getI18nHelper().getText("common.sharing.shared.project.not.found")));
        templates.put("share_invalid_role", StringEscapeUtils.escapeEcmaScript((String)authenticationContext.getI18nHelper().getText("common.sharing.shared.role.not.found")));
        if (mode == ShareTypeRenderer.RenderMode.EDIT) {
            templates.put("share_project_display_all", StringEscapeUtils.escapeEcmaScript((String)authenticationContext.getI18nHelper().getText("common.sharing.shared.template.project", "<b>", "</b>")));
            templates.put("share_project_display", StringEscapeUtils.escapeEcmaScript((String)authenticationContext.getI18nHelper().getText("common.sharing.shared.template.project.role", "<b>", "</b>", "<b>", "</b>")));
            templates.put("share_project_description", StringEscapeUtils.escapeEcmaScript((String)authenticationContext.getI18nHelper().getText("common.sharing.shared.template.project.desc")));
            templates.put("share_role_description", StringEscapeUtils.escapeEcmaScript((String)authenticationContext.getI18nHelper().getText("common.sharing.shared.template.project.role.desc")));
        } else if (mode == ShareTypeRenderer.RenderMode.SEARCH) {
            templates.put("share_project_description", StringEscapeUtils.escapeEcmaScript((String)authenticationContext.getI18nHelper().getText("common.sharing.search.template.project.desc." + type.getName())));
            templates.put("share_role_description", StringEscapeUtils.escapeEcmaScript((String)authenticationContext.getI18nHelper().getText("common.sharing.search.template.project.role.desc." + type.getName())));
        }
        return Collections.unmodifiableMap(templates);
    }

    public String getShareTypeEditor(JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        HashMap<String, Object> params = new HashMap<String, Object>();
        Collection<Project> projects = this.getProjects(authenticationContext.getUser());
        HashSet roles = new HashSet();
        HashMap<Long, String> rolesMap = new HashMap<Long, String>();
        for (Project project : projects) {
            JSONArray array = new JSONArray();
            List projectRoles = this.getProjectRolesForUser(authenticationContext.getUser(), project);
            roles.addAll(projectRoles);
            projectRoles = CollectionUtil.sort(projectRoles, ProjectRoleComparator.COMPARATOR);
            for (Object element : projectRoles) {
                ProjectRole role = (ProjectRole)element;
                array.put((Object)role.getId());
            }
            rolesMap.put(project.getId(), array.toString());
        }
        params.put(PROJECTS_KEY, CollectionUtil.sort(projects, (Comparator)ProjectNameComparator.COMPARATOR));
        params.put(ROLES_KEY, CollectionUtil.sort(roles, ProjectRoleComparator.COMPARATOR));
        params.put(ROLES_MAP, rolesMap);
        return this.renderVelocity("share-type-project-selector.vm", params, authenticationContext);
    }

    public boolean isAddButtonNeeded(JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        return !this.getProjects(authenticationContext.getUser()).isEmpty();
    }

    public String getShareTypeLabel(JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        return authenticationContext.getI18nHelper().getText("common.words.project");
    }

    private String getRole(SharePermission permission, JiraAuthenticationContext context) {
        String roleId = permission.getParam2();
        Project project = this.getProject(permission.getParam1());
        ProjectRole role = this.projectRoleManager.getProjectRole(new Long(roleId));
        if (role == null || !this.projectRoleManager.isUserInProjectRole(context.getLoggedInUser(), role, project) && !this.isProjectOrGlobalAdmin(project, context.getLoggedInUser())) {
            return context.getI18nHelper().getText("common.sharing.shared.role.not.found");
        }
        return TextUtil.escapeHTML((String)role.getName());
    }

    private Project getProject(String projectId) {
        return this.projectManager.getProjectObj(new Long(projectId));
    }

    private String getProject(String projectId, I18nHelper i18nHelper, ApplicationUser user) {
        Project project = this.getProject(projectId);
        if (project == null || !this.projectPermissionHelper.canUserBrowseProject(project, user) && !this.isProjectOrGlobalAdmin(project, user)) {
            return i18nHelper.getText("common.sharing.shared.project.not.found");
        }
        return TextUtil.escapeHTML((String)project.getName());
    }

    private Collection<Project> getProjects(ApplicationUser user) {
        return Optional.ofNullable(this.projectPermissionHelper.getBrowsableProjects(user)).orElse(Collections.emptyList());
    }

    private boolean isProjectOrGlobalAdmin(Project project, ApplicationUser user) {
        return this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user) || this.isAdministrator(user);
    }

    Collection<ProjectRole> getProjectRolesForUser(ApplicationUser user, Project project) {
        if (user == null) {
            return Collections.emptyList();
        }
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADMINS_CAN_SHARE_FILTERS_AND_DASHBOARDS_WITH_ALL_GROUPS_AND_ROLES) && this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            return this.projectRoleManager.getProjectRoles();
        }
        return this.projectRoleManager.getProjectRoles(user, project);
    }
}

