/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.index.IndexingFeatures;
import com.atlassian.jira.issue.index.analytics.JiraIndexingStatsAnalyticsEvent;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.atlassian.jira.service.services.analytics.JiraStartStopAnalyticHelper;
import com.atlassian.jira.service.services.analytics.start.JiraStartAnalyticEvent;
import com.atlassian.jira.service.services.analytics.stop.JiraStopAnalyticEvent;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsLauncher {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsLauncher.class);
    private final JiraStartStopAnalyticHelper jiraAnalyticHelper = new JiraStartStopAnalyticHelper();

    public void start() {
        if (this.isJiraSetup()) {
            this.runStartAnalyticsJob();
        }
    }

    public void stop() {
        if (this.isJiraSetup()) {
            this.getEventPublisher().publish((Object)new JiraStopAnalyticEvent(this.jiraAnalyticHelper.getOnStopUsageStats()));
        }
    }

    public EventPublisher getEventPublisher() {
        return (EventPublisher)ComponentAccessor.getComponentOfType(EventPublisher.class);
    }

    private boolean isJiraSetup() {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        return "true".equals(applicationProperties.getString("jira.setup"));
    }

    private void runStartAnalyticsJob() {
        JobRunnerKey runnerKey = JobRunnerKey.of((String)"com.atlassian.jira.startup.AnalyticsLauncher.Start");
        SchedulerService schedulerService = (SchedulerService)ComponentAccessor.getComponent(SchedulerService.class);
        if (schedulerService != null) {
            schedulerService.registerJobRunner(runnerKey, r -> {
                this.getEventPublisher().publish((Object)new JiraStartAnalyticEvent(this.jiraAnalyticHelper.getOnStartUsageStats(false)));
                this.getEventPublisher().publish((Object)this.getJiraStatsAnalyticsEvent());
                return JobRunnerResponse.success();
            });
            try {
                schedulerService.scheduleJobWithGeneratedId(JobConfig.forJobRunnerKey((JobRunnerKey)runnerKey).withSchedule(Schedule.runOnce((Date)new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(3L)))));
            }
            catch (SchedulerServiceException e) {
                log.error("Start analytics not scheduled", (Throwable)e);
            }
        }
    }

    private JiraIndexingStatsAnalyticsEvent getJiraStatsAnalyticsEvent() {
        IndexingFeatures indexingFeatures = (IndexingFeatures)ComponentAccessor.getComponentOfType(IndexingFeatures.class);
        FieldIndexerManager fieldIndexerManager = (FieldIndexerManager)ComponentAccessor.getComponentOfType(FieldIndexerManager.class);
        CustomFieldManager customFieldManager = ComponentAccessor.getCustomFieldManager();
        AtomicInteger notSupportingIndexers = new AtomicInteger();
        AtomicInteger indexersDeclaringNullHandling = new AtomicInteger();
        AtomicInteger indexersSkippingNull = new AtomicInteger();
        fieldIndexerManager.getCustomFieldIndexers().stream().map(FieldIndexer::skipsIndexingNull).forEach(skipsIndexingNull -> {
            if (skipsIndexingNull != null && skipsIndexingNull.booleanValue()) {
                indexersSkippingNull.getAndIncrement();
            } else if (skipsIndexingNull != null) {
                indexersDeclaringNullHandling.getAndIncrement();
            } else {
                notSupportingIndexers.getAndIncrement();
            }
        });
        List customFieldTypes = customFieldManager.getCustomFieldTypes();
        long customFieldsImplementingBatchCustomFieldInfo = customFieldTypes.stream().map(CustomFieldType::getNonNullCustomFieldProvider).filter(Objects::nonNull).filter(provider -> {
            Class<?> clazz = provider.getClass();
            try {
                return clazz.equals(clazz.getMethod("getCustomFieldInfo", List.class).getDeclaringClass());
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }).count();
        int totalIndexers = notSupportingIndexers.get() + indexersDeclaringNullHandling.get() + indexersSkippingNull.get();
        return new JiraIndexingStatsAnalyticsEvent(indexingFeatures, totalIndexers, indexersDeclaringNullHandling.get(), indexersSkippingNull.get(), customFieldTypes.size(), customFieldsImplementingBatchCustomFieldInfo);
    }
}

