/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.startup.JiraHomeStartupCheck;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.johnson.JiraJohnsonContainer;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.plugin.webresource.DefaultBigPipeConfiguration;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.ofbiz.core.entity.GenericDelegator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class ChecklistLauncher {
    private static final Logger log = LoggerFactory.getLogger(ChecklistLauncher.class);
    private final JiraProperties jiraSystemProperties;
    private final JohnsonProvider johnsonProvider;

    ChecklistLauncher(JiraProperties jiraSystemProperties, JohnsonProvider johnsonProvider) {
        this.jiraSystemProperties = jiraSystemProperties;
        this.johnsonProvider = johnsonProvider;
    }

    public void start() {
        try {
            this.setJiraDevMode();
            this.setupJiraDefaults();
            this.runStartupChecks();
        }
        catch (RuntimeException rte) {
            log.error("A RuntimeException occurred during ChecklistLauncher initialisation - " + rte.getMessage() + ".", (Throwable)rte);
            throw rte;
        }
        catch (Error error) {
            log.error("An Error occurred during ChecklistLauncher initialisation - " + error.getMessage() + ".", (Throwable)error);
            throw error;
        }
    }

    private void setupJiraDefaults() {
        ImmutableMap defaults = ImmutableMap.builder().put((Object)"plugin.webresource.batching.off", (Object)this.jiraSystemProperties.isDevMode()).put((Object)"plugin.webresource.javascript.try.catch.wrapping", (Object)true).put((Object)"atlassian.disable.spring.cache.bean.metadata", (Object)false).put((Object)"atlassian.renderer.max.emoticons", (Object)1000).put((Object)DefaultBigPipeConfiguration.BIGPIPE_DEADLINE_DISABLED, (Object)true).build();
        for (Map.Entry entry : defaults.entrySet()) {
            if (this.jiraSystemProperties.getProperty((String)entry.getKey()) != null) continue;
            this.jiraSystemProperties.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    public void stop() {
        JiraHomeStartupCheck.getInstance().stop();
        this.removeAllJohnsonEvents();
        this.deleteTemporaryAttachmentsDir();
        SLF4JBridgeHandler.uninstall();
    }

    private void removeAllJohnsonEvents() {
        JiraJohnsonContainer container = this.johnsonProvider.getContainer();
        container.getEvents().forEach(arg_0 -> ((JohnsonEventContainer)container).removeEvent(arg_0));
    }

    private void runStartupChecks() {
        JiraStartupLogger.log().info((Object)"Running Jira startup checks.");
        if (JohnsonProvider.isStartupOk()) {
            JiraStartupLogger.log().info((Object)"Jira pre-database startup checks completed successfully.");
        } else {
            JiraStartupLogger.log().fatal((Object)"Startup check failed. Jira will be locked.");
            GenericDelegator.lock();
        }
    }

    private void setJiraDevMode() {
        if (this.jiraSystemProperties.isDevMode()) {
            this.setDefault("atlassian.webresource.disable.minification", new String[0]);
            this.setDefault("atlassian.mail.senddisabled", new String[0]);
            this.setDefault("atlassian.mail.fetchdisabled", "atlassian.mail.popdisabled");
            this.setDefault("com.atlassian.gadgets.dashboard.ignoreCache", new String[0]);
            this.setDefault("atlassian.disable.caches", new String[0]);
            this.setDefault("atlassian.dev.mode", new String[0]);
            this.setDefault("jira.websudo.is.disabled", new String[0]);
            this.setDefault("jira.i18n.reloadbundles", new String[0]);
        }
    }

    private void setDefault(String key, String ... relatedKeys) {
        if (this.jiraSystemProperties.getProperty(key) != null) {
            log.debug("Trying to set already defined system property '" + key + "' to 'true' because development mode is on. Leaving as current value '" + this.jiraSystemProperties.getProperty(key) + "'.");
            return;
        }
        if (relatedKeys != null) {
            for (String relatedKey : relatedKeys) {
                String sysVal = this.jiraSystemProperties.getProperty(relatedKey);
                if (sysVal == null) continue;
                String mesg = "Trying to set system property '" + key + "' to 'true' because development mode is on. But related property '" + relatedKey + "' is already set to '" + sysVal + "'. So not setting.";
                if (sysVal.equals("true")) {
                    log.debug(mesg);
                } else {
                    log.warn(mesg);
                }
                return;
            }
        }
        log.info("Setting system property '" + key + "' to 'true' for development mode.");
        this.jiraSystemProperties.setProperty(key, (Object)"true");
    }

    private void deleteTemporaryAttachmentsDir() {
        try {
            File attachmentDirectory = AttachmentUtils.getTemporaryAttachmentDirectory();
            try {
                FileUtils.deleteDirectory((File)attachmentDirectory);
            }
            catch (IOException ioException) {
                log.warn("Warning: (" + ioException.getMessage() + ") deleting temporary attachments directory '" + attachmentDirectory + "' on shutdown. Ignoring since this is not required.", (Throwable)ioException);
            }
        }
        catch (Exception tempAttachmentsDirectoryNotRemovedException) {
            log.warn("Couldn't delete the temporary attachments directory.", (Throwable)tempAttachmentsDirectoryNotRemovedException);
        }
    }
}

