/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.instrumentation.operations.OpTimerFactory;
import com.atlassian.jdk.utilities.runtimeinformation.RuntimeInformationFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.util.DefaultJiraHome;
import com.atlassian.jira.health.HealthChecks;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.index.ha.DisasterRecoveryLauncher;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.startup.ActiveServicesLauncher;
import com.atlassian.jira.startup.BootstrapContainerLauncher;
import com.atlassian.jira.startup.CacheWarmerLauncher;
import com.atlassian.jira.startup.ChecklistLauncher;
import com.atlassian.jira.startup.ClusterNodeVersionCheckLauncher;
import com.atlassian.jira.startup.ClusteringLauncher;
import com.atlassian.jira.startup.ComponentContainerLauncher;
import com.atlassian.jira.startup.DatabaseChecklistLauncher;
import com.atlassian.jira.startup.DatabaseLauncher;
import com.atlassian.jira.startup.DeserializationFilterLauncher;
import com.atlassian.jira.startup.EmbeddedDatabaseServerLauncher;
import com.atlassian.jira.startup.FailedPluginsLauncher;
import com.atlassian.jira.startup.FlushStaleClusterTasksLauncher;
import com.atlassian.jira.startup.ImageIOProviderScannerLauncher;
import com.atlassian.jira.startup.IndexRecoveryLauncher;
import com.atlassian.jira.startup.NotificationInstanceKiller;
import com.atlassian.jira.startup.ReindexRequestCleaner;
import com.atlassian.jira.startup.SystemInfoLauncher;
import com.atlassian.jira.startup.TemporaryDirectoryCleaner;
import com.atlassian.jira.startup.ThreadDumper;
import com.atlassian.jira.startup.mode.StartupModeReference;
import com.atlassian.jira.upgrade.ConsistencyChecker;
import com.atlassian.jira.upgrade.ConsistencyCheckerImpl;
import com.atlassian.jira.upgrade.PluginSystemLauncher;
import com.atlassian.jira.util.StopWatch;
import com.atlassian.jira.util.devspeed.JiraDevSpeedTimer;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.johnson.event.Event;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.threadlocal.BruteForceThreadLocalCleanup;
import com.atlassian.threadlocal.RegisteredThreadLocals;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJiraLauncher {
    private static final Logger log = LoggerFactory.getLogger(DefaultJiraLauncher.class);
    private final ActiveServicesLauncher activeServicesLauncher;
    private final BootstrapContainerLauncher bootstrapContainerLauncher;
    private final CacheWarmerLauncher cacheWarmerLauncher;
    private final ChecklistLauncher startupChecklist;
    private final ClusteringLauncher clusteringLauncher;
    private final DeserializationFilterLauncher deserializationFilterLauncher;
    private final ComponentContainerLauncher componentContainerLauncher;
    private final ConsistencyChecker consistencyChecker;
    private final DatabaseLauncher databaseLauncher;
    private final ClusterNodeVersionCheckLauncher clusterNodeVersionCheckLauncher;
    private final DisasterRecoveryLauncher disasterRecoveryLauncher;
    private final EmbeddedDatabaseServerLauncher embeddedDatabaseServerLauncher;
    private final FailedPluginsLauncher postDbFailedPluginsLauncher;
    private final FailedPluginsLauncher preDbFailedPluginsLauncher;
    private final ImageIOProviderScannerLauncher imageIOProviderScannerLauncher;
    private final IndexRecoveryLauncher indexRecoveryLauncher;
    private final JiraProperties jiraSystemProperties;
    private final JohnsonProvider johnsonProvider;
    private final NotificationInstanceKiller notificationInstanceKiller;
    private final PluginSystemLauncher pluginSystemLauncher;
    private final ReindexRequestCleaner reindexRequestCleaner;
    private final SystemInfoLauncher systemInfoLauncher;
    private final FlushStaleClusterTasksLauncher flushStaleClusterTasksLauncher;
    private final TemporaryDirectoryCleaner temporaryDirectoryCleaner;

    public DefaultJiraLauncher(JohnsonProvider johnsonProvider) {
        this.johnsonProvider = johnsonProvider;
        this.jiraSystemProperties = JiraSystemProperties.getInstance();
        this.startupChecklist = new ChecklistLauncher(this.jiraSystemProperties, johnsonProvider);
        this.bootstrapContainerLauncher = new BootstrapContainerLauncher();
        this.componentContainerLauncher = new ComponentContainerLauncher();
        this.notificationInstanceKiller = new NotificationInstanceKiller();
        this.databaseLauncher = new DatabaseLauncher(this.jiraSystemProperties);
        this.pluginSystemLauncher = new PluginSystemLauncher(this.jiraSystemProperties);
        this.consistencyChecker = ConsistencyCheckerImpl.getInstance(johnsonProvider);
        this.systemInfoLauncher = new SystemInfoLauncher();
        this.preDbFailedPluginsLauncher = new FailedPluginsLauncher();
        this.postDbFailedPluginsLauncher = new FailedPluginsLauncher();
        this.clusteringLauncher = new ClusteringLauncher();
        this.deserializationFilterLauncher = new DeserializationFilterLauncher();
        this.clusterNodeVersionCheckLauncher = new ClusterNodeVersionCheckLauncher();
        this.activeServicesLauncher = new ActiveServicesLauncher(johnsonProvider);
        this.disasterRecoveryLauncher = new DisasterRecoveryLauncher();
        this.embeddedDatabaseServerLauncher = new EmbeddedDatabaseServerLauncher();
        this.reindexRequestCleaner = new ReindexRequestCleaner();
        this.indexRecoveryLauncher = new IndexRecoveryLauncher();
        this.imageIOProviderScannerLauncher = new ImageIOProviderScannerLauncher();
        this.cacheWarmerLauncher = new CacheWarmerLauncher(this.jiraSystemProperties);
        this.flushStaleClusterTasksLauncher = new FlushStaleClusterTasksLauncher();
        this.temporaryDirectoryCleaner = new TemporaryDirectoryCleaner(new DefaultJiraHome(), this.jiraSystemProperties);
    }

    public void start() {
        JiraThreadLocalUtils.preCall();
        try {
            JiraDevSpeedTimer.run(this.getStartupName(), () -> {
                this.preDbLaunch();
                this.postDbLaunch();
            });
        }
        finally {
            JiraThreadLocalUtils.postCall();
            JiraThreadLocalUtils.checkClosed(true);
        }
    }

    private void preDbLaunch() {
        this.systemInfoLauncher.start();
        this.temporaryDirectoryCleaner.start();
        this.bootstrapContainerLauncher.start();
        this.startupChecklist.start();
        this.imageIOProviderScannerLauncher.start();
        this.preDbFailedPluginsLauncher.start();
    }

    private void postDbLaunch() {
        if (JohnsonProvider.isStartupOk()) {
            DatabaseConfigurationManager dbcm = (DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class);
            this.embeddedDatabaseServerLauncher.start();
            dbcm.doNowOrWhenDatabaseConfigured(() -> new DatabaseChecklistLauncher(dbcm, this.johnsonProvider).start(), "Database Checklist Launcher");
            dbcm.doNowOrWhenDatabaseActivated(() -> {
                Collection<Event> blockerEvents = this.getEventsThatPreventStartup();
                if (blockerEvents.isEmpty()) {
                    this.componentContainerLauncher.start();
                    this.databaseLauncher.start();
                    this.recordStartupMode();
                    this.disasterRecoveryLauncher.earlyStart();
                    this.clusterNodeVersionCheckLauncher.start();
                    HealthChecks.runHealthChecks(LifecyclePhase.PRE_PLUGIN_SYSTEM_START);
                    this.pluginSystemLauncher.start();
                    this.postDBActivated();
                } else {
                    this.logEventsThatPreventStartup(blockerEvents);
                }
            }, "Post database-configuration launchers");
        }
    }

    private void recordStartupMode() {
        ((StartupModeReference)ComponentAccessor.getComponent(StartupModeReference.class)).initialise();
    }

    private Collection<Event> getEventsThatPreventStartup() {
        return this.johnsonProvider.getContainer().getEventsThatPreventStartup();
    }

    private void postDBActivated() {
        HealthChecks.runHealthChecks(LifecyclePhase.POST_DATABASE_ACTIVATED);
        Collection<Event> blockerEvents = this.getEventsThatPreventStartup();
        if (blockerEvents.isEmpty()) {
            this.consistencyChecker.initialise(ServletContextProvider.getServletContext());
            HealthChecks.runHealthChecks(LifecyclePhase.POST_CONSISTENCY_CHECKS);
            this.deserializationFilterLauncher.start();
            this.clusteringLauncher.start();
            this.reindexRequestCleaner.start();
            this.pluginSystemLauncher.lateStart();
            this.activeServicesLauncher.start();
            this.notificationInstanceKiller.deleteAfterDelay();
            this.disasterRecoveryLauncher.start();
            this.indexRecoveryLauncher.start();
            this.cacheWarmerLauncher.start();
            this.postDbFailedPluginsLauncher.start();
            this.flushStaleClusterTasksLauncher.start();
        } else {
            this.logEventsThatPreventStartup(blockerEvents);
        }
    }

    private void logEventsThatPreventStartup(Collection<Event> blockerEvents) {
        log.error("JIRA has failed to start because of the following errors: {}", blockerEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        OpTimerFactory opTimerFactory;
        log.info("Stopping launchers");
        StopWatch stopWatch = new StopWatch();
        ThreadDumper threadDumper = null;
        try {
            threadDumper = this.startDumper();
            ComponentAccessor.getComponentSafely(MailQueue.class).ifPresent(MailQueue::sendBuffer);
            this.clusteringLauncher.stop();
            this.activeServicesLauncher.stop();
            this.reindexRequestCleaner.stop();
            this.consistencyChecker.destroy(ServletContextProvider.getServletContext());
            this.pluginSystemLauncher.stop();
            this.databaseLauncher.stop();
            this.startupChecklist.stop();
            opTimerFactory = (OpTimerFactory)ComponentAccessor.getComponent(OpTimerFactory.class);
            this.componentContainerLauncher.stop();
            this.embeddedDatabaseServerLauncher.stop();
        }
        finally {
            if (threadDumper != null) {
                threadDumper.cancelDump();
            }
        }
        this.cleanupAfterOurselves(opTimerFactory, stopWatch);
    }

    private void cleanupAfterOurselves(OpTimerFactory opTimerFactory, StopWatch stopWatch) {
        this.cleanupThreadLocals(opTimerFactory);
        this.logShutDownTime(stopWatch);
        LogManager.shutdown();
    }

    private void logShutDownTime(StopWatch stopWatch) {
        long elapsedTime = stopWatch.getTotalTime();
        String logKey = this.jiraSystemProperties.getBoolean("skip.plugin.system.shutdown") != false ? "jira.launcher.stop.instant.millis" : "jira.launcher.stop.millis";
        MDC.put((String)logKey, (Object)elapsedTime);
        log.info("JIRA launchers stopped in {}ms", (Object)elapsedTime);
        MDC.remove((String)logKey);
    }

    private ThreadDumper startDumper() {
        ThreadDumper threadDumper = new ThreadDumper(TimeUnit.MINUTES.toMillis(4L));
        if (this.jiraSystemProperties.isDevMode() || this.jiraSystemProperties.getBoolean("jira.dump").booleanValue()) {
            Thread thread = new Thread((Runnable)threadDumper, "Thread-dumping thread from " + this.getClass().getSimpleName());
            thread.setDaemon(true);
            thread.start();
        }
        return threadDumper;
    }

    private void cleanupThreadLocals(OpTimerFactory opTimerFactory) {
        Instrumentation.snapshotThreadLocalOperationsAndClear(opTimerFactory);
        RegisteredThreadLocals.reset();
        BruteForceThreadLocalCleanup.cleanUp((ClassLoader)this.getClass().getClassLoader());
    }

    private String getStartupName() {
        String jvmInputArguments = StringUtils.defaultString((String)RuntimeInformationFactory.getRuntimeInformation().getJvmInputArguments());
        boolean rebel = jvmInputArguments.contains("jrebel.jar");
        boolean debugMode = jvmInputArguments.contains("-agentlib:jdwp");
        return "jira.startup" + (debugMode ? ".debug" : ".run") + (rebel ? ".jrebel" : "");
    }
}

