/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JiraHomeStartupCheckFailure {
    private final String configuredHome;
    private final String proposedHome;
    private final String subDirectory;
    private final String webappPath;
    private final Reason reason;

    @Nonnull
    public static JiraHomeStartupCheckFailure missingConfiguration(@Nonnull Reason reason) {
        return new JiraHomeStartupCheckFailure(reason, null, null, null, null);
    }

    @Nonnull
    public static JiraHomeStartupCheckFailure badConfiguredJiraHome(@Nonnull Reason reason, @Nonnull String configuredHome) {
        return new JiraHomeStartupCheckFailure(reason, configuredHome, null, null, null);
    }

    @Nonnull
    public static JiraHomeStartupCheckFailure badProposedJiraHome(@Nonnull Reason reason, @Nonnull String proposedHome) {
        return new JiraHomeStartupCheckFailure(reason, null, proposedHome, null, null);
    }

    @Nonnull
    public static JiraHomeStartupCheckFailure webappPathCollision(@Nonnull Reason reason, @Nonnull String proposedHome, @Nonnull String webappPath) {
        return new JiraHomeStartupCheckFailure(reason, null, proposedHome, null, webappPath);
    }

    @Nonnull
    public static JiraHomeStartupCheckFailure badSubdirectory(@Nonnull Reason reason, @Nonnull String proposedHome, @Nonnull String subDirectory) {
        return new JiraHomeStartupCheckFailure(reason, null, proposedHome, subDirectory, null);
    }

    private JiraHomeStartupCheckFailure(@Nonnull Reason reason, @Nullable String configuredHome, @Nullable String proposedHome, @Nullable String subDirectory, @Nullable String webappPath) {
        this.reason = Objects.requireNonNull(reason);
        this.configuredHome = configuredHome;
        this.proposedHome = proposedHome;
        this.subDirectory = subDirectory;
        this.webappPath = webappPath;
    }

    @Nonnull
    public Reason getReason() {
        return this.reason;
    }

    @Nonnull
    public String getConfiguredHome() {
        return Objects.requireNonNull(this.configuredHome);
    }

    @Nonnull
    public String getProposedHome() {
        return Objects.requireNonNull(this.proposedHome);
    }

    @Nonnull
    public String getSubDirectory() {
        return Objects.requireNonNull(this.subDirectory);
    }

    @Nonnull
    public String getWebappPath() {
        return Objects.requireNonNull(this.webappPath);
    }

    public static enum Reason {
        NOT_CONFIGURED("not-configured"),
        PATH_NOT_ABSOLUTE("path-not-absolute"),
        PATH_NOT_ABSOLUTE_BUT_WINDOWS_LIKE("path-not-absolute-windows-like"),
        PATH_COLLISION_WEBAPP_SERVLET("collision-webapp"),
        PATH_COLLISION_WEBAPP_SERVLET_PARENT("collision-webapp-parent"),
        PATH_COLLISION_WEBAPP_SERVLET_CHILD("collision-webapp-child"),
        PATH_COLLISION_WEBAPP_SERVLET_FAILED("collision-webapp-failed"),
        NOT_A_DIR("not-a-dir"),
        CREATION_NOT_POSSIBLE("creation-failed"),
        CREATION_FAILED_SUBDIR("creation-not-possible"),
        CREATION_FAILED_SECURITY("creation-failed-sec"),
        CREATION_FAILED_WRITE_PERMISSION_SUBDIR("creation-failed-write-permission-subdir"),
        LOCK_ALREADY_EXISTS("lock-already-exists"),
        LOCK_FAILED_CREATION("lock-failed-creation");

        private final String analyticsValue;

        private Reason(String analyticsValue) {
            this.analyticsValue = Objects.requireNonNull(analyticsValue);
        }

        @Nonnull
        public String getAnalyticsValue() {
            return this.analyticsValue;
        }
    }
}

