/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.cache.JiraVCacheRequestContextSupplier;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentAccessorWorker;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.instrumentation.jdbc.InstantLogJdbcStatsCollector;
import com.atlassian.jira.startup.DefaultJiraLauncher;
import com.atlassian.jira.startup.JiraHomeStartupCheck;
import com.atlassian.jira.util.MemoryPools;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.jira.util.johnson.DefaultJohnsonProvider;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.web.startup.StartupPageSupport;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class LauncherContextListener
implements ServletContextListener {
    @VisibleForTesting
    static final String SYNCHRONOUS = LauncherContextListener.class.getName() + ".SYNCHRONOUS";
    private static final Logger log = LoggerFactory.getLogger(LauncherContextListener.class);
    private static final String PROPERTY_LOG_JDBC_ON_STARTUP = "jira.jdbc.startup.logging";
    private static final String JDBC_STARTUP_LOGGER_NAME = "jdbc.startup.log";
    private static final String STARTUP_UNEXPECTED = "startup-unexpected";
    private static final int DEADLOCK_DETECTION_PERIOD = 5;
    private final JiraProperties jiraProperties;
    private final JohnsonProvider johnsonProvider;
    private final ScheduledExecutorService deadlockDetectionService;
    private volatile Thread bootstrap;
    private volatile DefaultJiraLauncher launcher;
    private InstantLogJdbcStatsCollector jdbcStatsCollector;

    public LauncherContextListener() {
        this(JiraSystemProperties.getInstance(), new DefaultJohnsonProvider(), Executors.newSingleThreadScheduledExecutor(ThreadFactories.namedThreadFactory("DeadlockDetection")));
    }

    private LauncherContextListener(JiraProperties jiraProperties, JohnsonProvider johnsonProvider, ScheduledExecutorService deadlockDetectionService) {
        this.deadlockDetectionService = Objects.requireNonNull(deadlockDetectionService);
        this.jiraProperties = Objects.requireNonNull(jiraProperties);
        this.johnsonProvider = Objects.requireNonNull(johnsonProvider);
    }

    public void contextInitialized(ServletContextEvent sce) {
        if (this.bootstrap != null || this.launcher != null) {
            throw new IllegalStateException("JIRA cannot be initialized twice!");
        }
        try {
            JiraVCacheRequestContextSupplier.initStaticContext("staticStartupContext");
            this.initStartupJdbcLogging();
            this.initFastStuff();
            this.initSlowStuffInBackground();
        }
        catch (Exception e) {
            this.fatalJohnson(e);
        }
        finally {
            JiraVCacheRequestContextSupplier.clearStaticContext();
            this.finishStartupJdbcLogging();
        }
    }

    private void initStartupJdbcLogging() {
        boolean shouldLog = this.jiraProperties.getBoolean(PROPERTY_LOG_JDBC_ON_STARTUP);
        if (shouldLog) {
            try {
                Class.forName("com.atlassian.instrumentation.driver.Instrumentation");
                org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)JDBC_STARTUP_LOGGER_NAME);
                this.jdbcStatsCollector = new InstantLogJdbcStatsCollector(logger);
                this.jdbcStatsCollector.register();
            }
            catch (ClassNotFoundException e) {
                log.debug("No metrics driver present - startup jdbc logging will be disabled");
            }
        }
    }

    private void finishStartupJdbcLogging() {
        if (this.jdbcStatsCollector != null) {
            this.jdbcStatsCollector.unregister();
            this.jdbcStatsCollector = null;
        }
    }

    private void initFastStuff() {
        log.debug("Launching JIRA");
        ComponentAccessor.initialiseWorker((ComponentAccessor.Worker)ComponentAccessorWorker.getInstance());
    }

    private void initSlowStuffInBackground() {
        if (this.isSynchronousStartup()) {
            this.initSlowStuff();
        } else {
            Thread bootstrap;
            this.bootstrap = bootstrap = new Thread(this::initSlowStuff, "JIRA-Bootstrap");
            bootstrap.start();
        }
    }

    private void initSlowStuff() {
        log.debug("Startup deadlock detector launched...");
        ScheduledFuture<?> deadLockDetector = this.deadlockDetectionService.scheduleAtFixedRate(new DeadlockDetector(), 0L, 5L, TimeUnit.SECONDS);
        try {
            this.launcher = new DefaultJiraLauncher(this.johnsonProvider);
            this.launcher.start();
        }
        catch (Exception e) {
            this.fatalJohnson(e);
        }
        catch (Error e) {
            this.fatalJohnson(e);
            throw e;
        }
        finally {
            deadLockDetector.cancel(false);
            this.deadlockDetectionService.shutdown();
            log.debug("Startup deadlock detector finished.");
            this.initDone();
        }
        log.info("Memory Usage:\n" + MemoryPools.memoryPoolsDump(false));
    }

    private void fatalJohnson(Throwable e) {
        log.error("Unable to start JIRA.", e);
        this.johnsonProvider.getContainer().addEvent(new Event(EventType.get((String)STARTUP_UNEXPECTED), "Unexpected exception during JIRA startup. This JIRA instance will not be able to recover. Please check the logs for details", this.stackTrace(e), EventLevel.get((String)"fatal")));
    }

    /*
     * Exception decompiling
     */
    private String stackTrace(Throwable t) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initDone() {
        if (!ComponentManager.getInstance().getState().isStarted() && !this.johnsonProvider.getContainer().hasEventThatPreventsStartup()) {
            this.fatalJohnson(new IllegalStateException("Abnormal system startup detected"));
        }
        StartupPageSupport.setLaunched(true);
        log.info("Startup is complete. Jira is ready to serve.");
        this.bootstrap = null;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.interruptBootstrap();
        if (this.launcher == null) {
            throw new IllegalStateException("Context destroyed without being initialized first. JIRA launcher is confused.");
        }
        this.launcher.stop();
        this.launcher = null;
    }

    private void interruptBootstrap() {
        Thread bootstrap = this.bootstrap;
        if (bootstrap == null) {
            return;
        }
        this.bootstrap = null;
        bootstrap.interrupt();
        try {
            bootstrap.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isClustered() {
        return (Boolean)JiraHomeStartupCheck.getInstance().getJiraHomeDirectory().fold(failure -> false, homeDir -> new File((File)homeDir, "cluster.properties").exists());
    }

    private boolean isSynchronousStartup() {
        return this.jiraProperties.getBoolean(SYNCHRONOUS) != false || LauncherContextListener.isClustered();
    }

    private static final class DeadlockDetectedException
    extends RuntimeException {
        private DeadlockDetectedException() {
        }
    }

    private static class DeadlockDetector
    implements Runnable {
        private static final String DEAD_LOCK_DETECTOR_KB_URL = "https://confluence.atlassian.com/display/JIRAKB/Deadlock+detected+on+startup+error+in+logfile";
        private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

        private DeadlockDetector() {
        }

        @Override
        public void run() {
            long[] threadIds = this.threadMXBean.findDeadlockedThreads();
            if (threadIds != null) {
                ArrayList threadInfoStrings = Lists.newArrayList();
                for (ThreadInfo threadInfo : this.threadMXBean.getThreadInfo(threadIds, 0)) {
                    threadInfoStrings.add(StringUtils.trim((String)threadInfo.toString()));
                }
                log.error(String.format("A deadlock has been detected on JIRA startup for the following threads: %s", threadInfoStrings));
                for (ThreadInfo threadInfo : this.threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE)) {
                    log.error(DeadlockDetector.generateStackTrace(threadInfo));
                }
                log.error(String.format("Further troubleshooting information about this issue is available in the KB article at: %s", DEAD_LOCK_DETECTOR_KB_URL));
                throw new DeadlockDetectedException();
            }
        }

        private static String generateStackTrace(ThreadInfo threadInfo) {
            StackTraceElement[] stackTrace;
            StringBuilder stackTraceString = new StringBuilder();
            stackTraceString.append(StringUtils.trim((String)threadInfo.toString())).append(":\n");
            for (StackTraceElement stackTraceElement : stackTrace = threadInfo.getStackTrace()) {
                stackTraceString.append('\t').append(stackTraceElement.toString()).append('\n');
            }
            return stackTraceString.toString();
        }
    }
}

