/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup.mode;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.instance.InstanceStateProvider;
import com.atlassian.jira.startup.mode.StartupMode;
import com.atlassian.jira.startup.mode.StartupModeReference;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DefaultStartupModeReference
implements StartupModeReference {
    @ClusterSafe(value="Represents an individual node's state")
    private final AtomicReference<StartupMode> startupModeRef = new AtomicReference<StartupMode>(StartupMode.UNKNOWN);
    private final InstanceStateProvider instanceStateProvider;

    public DefaultStartupModeReference(InstanceStateProvider instanceStateProvider) {
        this.instanceStateProvider = Objects.requireNonNull(instanceStateProvider);
    }

    @Override
    public void initialise() {
        boolean wasUnknown = this.startupModeRef.compareAndSet(StartupMode.UNKNOWN, this.determineStartupMode());
        if (!wasUnknown) {
            throw new IllegalStateException("Mode was already set to " + (Object)((Object)this.startupModeRef.get()));
        }
    }

    private StartupMode determineStartupMode() {
        switch (this.instanceStateProvider.currentState()) {
            case INSTALLING: {
                return StartupMode.INSTALLING;
            }
            case UPGRADE_REQUIRED: {
                return StartupMode.UPGRADING;
            }
        }
        return StartupMode.NORMAL;
    }

    @Override
    @Nonnull
    public StartupMode get() {
        return this.startupModeRef.get();
    }
}

