/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.operation.SpanningOperation;
import com.atlassian.jira.event.operation.SpanningOperationHolder;
import com.atlassian.jira.task.AlreadyExecutingException;
import com.atlassian.jira.task.ImportTaskManager;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.RequiresTaskInformation;
import com.atlassian.jira.task.SelfRecovering;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskDescriptorImpl;
import com.atlassian.jira.task.TaskProgressAdapter;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class ImportTaskManagerImpl
implements ImportTaskManager {
    private static final Logger log = Logger.getLogger(ImportTaskManagerImpl.class);
    private final AtomicReference<TaskDescriptorImpl<?>> currentTask = new AtomicReference();
    private final ExecutorService executorService;
    private final Map<String, String> cachedResourceBundleStrings = new ConcurrentHashMap<String, String>();
    private final ClusterManager clusterManager;

    public ImportTaskManagerImpl() {
        this.executorService = Executors.newSingleThreadExecutor(new TaskManagerThreadFactory());
        this.clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
    }

    @Override
    public void prepareCachedResourceBundleStrings(Locale locale) {
        this.clearCachedResourceBundleStrings();
        I18nHelper i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(locale);
        ArrayList tmpResourceBundleStrings = new ArrayList(i18nHelper.getKeysForPrefix(""));
        for (String key : tmpResourceBundleStrings) {
            this.cachedResourceBundleStrings.put(key, i18nHelper.getUnescapedText(key));
        }
    }

    @Override
    public Map<String, String> getCachedResourceBundleStrings() {
        return this.cachedResourceBundleStrings;
    }

    @Override
    public void clearCachedResourceBundleStrings() {
        this.cachedResourceBundleStrings.clear();
    }

    @Override
    public <V extends Serializable> TaskDescriptor<V> submitTask(@Nonnull Callable<V> callable, String taskName) throws RejectedExecutionException {
        return this.submitTask(callable, taskName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V extends Serializable> TaskDescriptor<V> submitTask(@Nonnull Callable<V> callable, String taskName, @Nullable SpanningOperation spanningOperation) throws RejectedExecutionException {
        Assertions.notNull((String)"callable", callable);
        TaskProgressAdapter taskProgressAdapter = null;
        if (callable instanceof ProvidesTaskProgress) {
            taskProgressAdapter = new TaskProgressAdapter();
        }
        boolean selfRecovering = callable instanceof SelfRecovering;
        TaskDescriptorImpl taskDescriptor = new TaskDescriptorImpl(1L, taskName, new NoOpTaskContext(), null, taskProgressAdapter, false, this.clusterManager.getNodeId(), spanningOperation, selfRecovering);
        FutureTask futureTask = new FutureTask(new TaskCallableDecorator(callable, taskDescriptor, (SpanningOperationHolder)ComponentAccessor.getComponent(SpanningOperationHolder.class)));
        if (callable instanceof ProvidesTaskProgress) {
            taskProgressAdapter.setTaskDescriptor(taskDescriptor);
            ((ProvidesTaskProgress)((Object)callable)).setTaskProgressSink(taskProgressAdapter);
        }
        if (callable instanceof RequiresTaskInformation) {
            RequiresTaskInformation requiresTaskInformation = (RequiresTaskInformation)((Object)callable);
            requiresTaskInformation.setTaskDescriptor(taskDescriptor);
        }
        ImportTaskManagerImpl importTaskManagerImpl = this;
        synchronized (importTaskManagerImpl) {
            if (this.currentTask.get() != null) {
                throw new AlreadyExecutingException(this.currentTask.get(), "A task with this context has already been submitted");
            }
            this.currentTask.set(taskDescriptor);
        }
        this.executorService.submit(futureTask);
        return new TaskDescriptorImpl(taskDescriptor);
    }

    @Override
    public void shutdownNow() {
        this.executorService.shutdownNow();
    }

    @Override
    public <V extends Serializable> TaskDescriptor<V> getTask() {
        return ImportTaskManagerImpl.copy(this.currentTask.get());
    }

    private static <V extends Serializable> TaskDescriptor<V> copy(TaskDescriptorImpl<V> input) {
        if (input == null) {
            return null;
        }
        return new TaskDescriptorImpl<V>(input);
    }

    static class NoOpTaskContext
    implements TaskContext {
        NoOpTaskContext() {
        }

        @Override
        public String buildProgressURL(Long taskId) {
            return "";
        }
    }

    private static class TaskManagerThreadFactory
    implements ThreadFactory {
        private final AtomicLong threadId = new AtomicLong(0L);

        private TaskManagerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, "JiraImportTaskExecutionThread-" + this.threadId.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    }

    private static class TaskCallableDecorator<V extends Serializable>
    implements Callable<V> {
        private final AtomicReference<Callable<V>> actualCallableRef;
        private final TaskDescriptorImpl<V> taskDescriptor;
        private final SpanningOperationHolder spanningOperationHolder;

        private TaskCallableDecorator(Callable<V> callable, TaskDescriptorImpl<V> taskDescriptor, SpanningOperationHolder spanningOperationHolder) {
            Assertions.notNull((String)"callable", callable);
            Assertions.notNull((String)"taskDescriptor", taskDescriptor);
            Assertions.notNull((String)"spanningOperationHolder", (Object)spanningOperationHolder);
            this.actualCallableRef = new AtomicReference<Callable<Callable<V>>>(callable);
            this.taskDescriptor = taskDescriptor;
            this.spanningOperationHolder = spanningOperationHolder;
        }

        @Override
        public V call() throws Exception {
            this.preCallSetup();
            this.taskDescriptor.setStartedTimestamp();
            try {
                Callable actualCallable = this.actualCallableRef.getAndSet(null);
                if (actualCallable != null) {
                    Serializable result = (Serializable)actualCallable.call();
                    this.taskDescriptor.setResult(result);
                    Serializable serializable = result;
                    return (V)serializable;
                }
                throw new IllegalStateException("Callable executed twice.");
            }
            finally {
                this.postCallTearDown();
            }
        }

        private void preCallSetup() {
            JiraThreadLocalUtils.preCall();
            this.spanningOperationHolder.set(this.taskDescriptor.getSpanningOperation());
        }

        private void postCallTearDown() {
            this.taskDescriptor.setFinishedTimestamp();
            JiraThreadLocalUtils.postCall(log, new JiraThreadLocalUtil.WarningCallback(){

                public void onOpenTransaction() {
                    log.error((Object)("The task '" + taskDescriptor.getDescription() + "' has left an open database transaction in play."));
                }
            });
        }
    }
}

