/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template.validator;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.template.TemplateValidationConfigProvider;
import com.atlassian.jira.template.TemplatesValidationConfig;
import com.atlassian.jira.template.validator.TemplateValidatorService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTemplateValidatorService
implements TemplateValidatorService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTemplateValidatorService.class);
    private static final String HTML = "html";
    private static final String TEXT = "text";
    private static final String MISSING_FILES_MESSAGE = "missingFiles";
    private static final String VALIDATION_FAILED = "validationFailed";
    private final TemplateValidationConfigProvider templateValidationConfigProvider;

    public DefaultTemplateValidatorService(TemplateValidationConfigProvider templateValidationConfigProvider) {
        this.templateValidationConfigProvider = templateValidationConfigProvider;
    }

    @Override
    public ServiceOutcome<Void> validateTemplatesFolder(String folderToCheck) {
        Map<String, String> templatesMap = this.readTemplates(this.templateValidationConfigProvider);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        for (Map.Entry<String, String> entry : templatesMap.entrySet()) {
            File templateFile = new File(folderToCheck, entry.getKey());
            if (templateFile.exists()) continue;
            errorCollection.addErrorMessage(entry.getKey(), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (errorCollection.hasAnyErrors()) {
            errorCollection.addError(VALIDATION_FAILED, MISSING_FILES_MESSAGE);
            return ServiceOutcomeImpl.from((ErrorCollection)errorCollection);
        }
        return ServiceOutcomeImpl.ok(null);
    }

    private Map<String, String> readTemplates(TemplateValidationConfigProvider templateValidationConfigProvider) {
        TemplatesValidationConfig templatesValidationConfig = templateValidationConfigProvider.get();
        HashMap<String, String> templatesMap = new HashMap<String, String>();
        for (TemplatesValidationConfig.TemplateInfo templateInfo : templatesValidationConfig.getTemplateConfigs().values()) {
            if (!templateInfo.isUseForValidation()) continue;
            if (templateInfo.isHtml()) {
                templatesMap.put(templateInfo.getFolder() + File.separator + HTML + File.separator + templateInfo.getTemplate(), templateInfo.getTemplate());
            }
            if (!templateInfo.isText()) continue;
            templatesMap.put(templateInfo.getFolder() + File.separator + TEXT + File.separator + templateInfo.getTemplate(), templateInfo.getTemplate());
        }
        LOG.info("Returning {} templates for validation", (Object)templatesMap.size());
        return templatesMap;
    }
}

