/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.transaction;

import com.atlassian.jira.transaction.RunnablesQueue;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@NotThreadSafe
class RunnablesQueueImpl
implements RunnablesQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunnablesQueueImpl.class);
    final Queue<Runnable> runnableQueue = new LinkedList<Runnable>();
    boolean running = false;

    RunnablesQueueImpl() {
    }

    @Override
    public void offer(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        this.runnableQueue.add(runnable);
    }

    @Override
    public void clear() {
        if (this.running) {
            LOGGER.debug("Not clearing queue is it is being processed.");
            return;
        }
        this.runnableQueue.clear();
    }

    @Override
    public void runAndClear() {
        if (this.running) {
            LOGGER.debug("Queue is already being processed.");
            return;
        }
        this.running = true;
        try {
            Runnable runnable;
            LOGGER.debug("About to begin executing runnables in queue.");
            while ((runnable = this.runnableQueue.poll()) != null) {
                LOGGER.debug("Executing a runnable from queue.");
                this.runIt(runnable);
            }
            LOGGER.debug("Finished executing all runnables in queue.");
        }
        finally {
            this.running = false;
            LOGGER.debug("Queue is available to be processed again.");
        }
    }

    private void runIt(Runnable codeToRun) {
        SafePluginPointAccess.to().runnable(codeToRun);
    }

    @VisibleForTesting
    Queue<Runnable> queue() {
        return this.runnableQueue;
    }
}

