/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.transition;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.transition.DefaultTransitionEntry;
import com.atlassian.jira.transition.DefaultWorkflowTransitionEntry;
import com.atlassian.jira.transition.TransitionEntry;
import com.atlassian.jira.transition.TransitionManager;
import com.atlassian.jira.transition.WorkflowTransitionEntry;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.google.common.primitives.Longs;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultTransitionManager
implements TransitionManager {
    public Collection<WorkflowTransitionEntry> getTransitions(@Nullable Collection<JiraWorkflow> workflows) {
        if (CollectionUtils.isEmpty(workflows)) {
            return Collections.emptyList();
        }
        return (Collection)workflows.stream().distinct().map(this::toWorkflowTransitionEntry).collect(CollectorsUtil.toImmutableList());
    }

    private WorkflowTransitionEntry toWorkflowTransitionEntry(JiraWorkflow workflow) {
        List statuses = workflow.getLinkedStatusObjects();
        List workflowTransitions = (List)statuses.stream().flatMap(status -> {
            StepDescriptor linkedStep = workflow.getLinkedStep(status);
            Collection previousActions = workflow.getActionsWithResult(linkedStep);
            Stream<TransitionEntry> initialTransitions = previousActions.stream().filter(arg_0 -> ((JiraWorkflow)workflow).isInitialAction(arg_0)).map(action -> {
                Status nextStatus = this.getStatusForAction(workflow, (ActionDescriptor)action);
                return this.getTransitionEntry((ActionDescriptor)action, null, nextStatus, false, true);
            });
            Stream<TransitionEntry> globalTransitions = previousActions.stream().filter(arg_0 -> ((JiraWorkflow)workflow).isGlobalAction(arg_0)).map(action -> {
                Status nextStatus = this.getStatusForAction(workflow, (ActionDescriptor)action);
                return this.getTransitionEntry((ActionDescriptor)action, null, nextStatus, true, false);
            });
            List actions = linkedStep.getActions();
            Stream<TransitionEntry> normalTransitions = actions.stream().map(action -> {
                Status nextStatus = this.getStatusForAction(workflow, (ActionDescriptor)action);
                return this.getTransitionEntry((ActionDescriptor)action, (Status)status, nextStatus, false, false);
            });
            return Stream.concat(Stream.concat(initialTransitions, globalTransitions), normalTransitions);
        }).collect(CollectorsUtil.toImmutableList());
        return new DefaultWorkflowTransitionEntry(workflow, workflowTransitions);
    }

    private TransitionEntry getTransitionEntry(ActionDescriptor transition, Status previousStatus, Status nextStatus, boolean isGlobal, boolean isInitial) {
        boolean hasScreen = StringUtils.isNotEmpty((CharSequence)transition.getView());
        boolean hasConditions = Optional.ofNullable(transition.getRestriction()).map(RestrictionDescriptor::getConditionsDescriptor).map(ConditionsDescriptor::getConditions).map(CollectionUtils::isNotEmpty).orElse(false);
        boolean hasValidators = CollectionUtils.isNotEmpty((Collection)transition.getValidators());
        Long previousStatusId = previousStatus != null ? Longs.tryParse((String)previousStatus.getId()) : null;
        return new DefaultTransitionEntry(transition.getId(), previousStatusId, Longs.tryParse((String)nextStatus.getId()), transition.getName(), hasScreen, hasConditions, hasValidators, isInitial, isGlobal);
    }

    private Status getStatusForAction(JiraWorkflow workflow, ActionDescriptor action) {
        int stepId = action.getUnconditionalResult().getStep();
        StepDescriptor step = workflow.getDescriptor().getStep(stepId);
        return workflow.getLinkedStatus(step);
    }
}

