/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.upgrade.LicenseCheckingUpgradeService;
import com.atlassian.jira.upgrade.UpgradeResult;
import com.atlassian.jira.upgrade.UpgradeService;
import com.atlassian.upgrade.api.UpgradeContext;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterLockingUpgradeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterLockingUpgradeService.class);
    private static final String UPGRADE_FRAMEWORK_LOCKED_ERROR = "Could not acquire the lock for running upgrades";
    private final ClusterLockService clusterLockService;
    private final LicenseCheckingUpgradeService licenseCheckingUpgradeService;

    public ClusterLockingUpgradeService(ClusterLockService clusterLockService, LicenseCheckingUpgradeService licenseCheckingUpgradeService) {
        this.clusterLockService = clusterLockService;
        this.licenseCheckingUpgradeService = licenseCheckingUpgradeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult runUpgrades(Set<ReindexRequestType> reindexRequestTypes, UpgradeContext upgradeContext) {
        ClusterLock lock = this.getClusterLock();
        if (lock.tryLock()) {
            try {
                UpgradeResult upgradeResult = this.licenseCheckingUpgradeService.runUpgrades(reindexRequestTypes, upgradeContext);
                return upgradeResult;
            }
            finally {
                lock.unlock();
            }
        }
        LOGGER.error("The Upgrade Service has been locked as there is another attempt to run upgrades.");
        return new UpgradeResult(UPGRADE_FRAMEWORK_LOCKED_ERROR);
    }

    private ClusterLock getClusterLock() {
        return this.clusterLockService.getLockForName(UpgradeService.class.getName());
    }

    public boolean areUpgradesRunning() {
        ClusterLock lock = this.getClusterLock();
        if (lock.tryLock()) {
            lock.unlock();
            return false;
        }
        return true;
    }
}

