/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.config.properties.PropertiesManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.upgrade.core.LegacyUpgradeTaskBuildNumberStorage;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Optional;
import javax.annotation.Nonnull;

public class LegacyUpgradeTaskBuildNumberStorageImpl
extends LegacyUpgradeTaskBuildNumberStorage {
    private final PropertiesManager propertiesManager;

    public LegacyUpgradeTaskBuildNumberStorageImpl(PropertiesManager propertiesManager) {
        this.propertiesManager = propertiesManager;
    }

    @Nonnull
    protected Optional<Integer> getIntegerPluginSetting(String key) {
        String value;
        Assertions.notNull((String)"key", (Object)key);
        PropertySet propertySet = this.propertiesManager.getPropertySet();
        if (!propertySet.exists(key)) {
            return Optional.empty();
        }
        switch (propertySet.getType(key)) {
            case 5: {
                value = propertySet.getString(key);
                break;
            }
            case 6: {
                value = propertySet.getText(key);
                break;
            }
            default: {
                value = null;
            }
        }
        return Optional.ofNullable(value).map(Integer::valueOf);
    }

    protected void putIntegerPluginSetting(String key, int i) {
        Assertions.notNull((String)"key", (Object)key);
        PropertySet propertySet = this.propertiesManager.getPropertySet();
        if (propertySet.exists(key)) {
            propertySet.remove(key);
        }
        propertySet.setString(key, String.valueOf(i));
    }
}

