/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.auditing.AuditingManager;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.CustomFieldHandler;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.field.CustomFieldDetails;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.model.querydsl.CustomFieldDTO;
import com.atlassian.jira.model.querydsl.FieldConfigSchemeDTO;
import com.atlassian.jira.model.querydsl.FieldConfigurationDTO;
import com.atlassian.jira.model.querydsl.FieldLayoutItemDTO;
import com.atlassian.jira.model.querydsl.IssueTypeDTO;
import com.atlassian.jira.model.querydsl.ProjectRoleDTO;
import com.atlassian.jira.model.querydsl.QCustomField;
import com.atlassian.jira.model.querydsl.QFieldConfigScheme;
import com.atlassian.jira.model.querydsl.QFieldConfiguration;
import com.atlassian.jira.model.querydsl.QFieldLayoutItem;
import com.atlassian.jira.model.querydsl.QIssueType;
import com.atlassian.jira.model.querydsl.QProjectRole;
import com.atlassian.jira.model.querydsl.QSearchRequest;
import com.atlassian.jira.model.querydsl.SearchRequestDTO;
import com.atlassian.jira.upgrade.UpgradeVersionHistoryReader;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UntranslatedKeyFixer {
    private static final Logger log = LoggerFactory.getLogger(UntranslatedKeyFixer.class);
    static final String APPLICATION_PROPERTY_KEY_FIXER_DISABLED = "com.atlassian.jira.upgrade.untranslatedkeyfixer.disabled";
    private static final Pattern VERSION_REGEX = Pattern.compile("([0-9]+\\.[0-9]+\\.[0-9]+).*");
    private static final Set<String> AFFECTED_VERSIONS = ImmutableSet.of((Object)"8.2.0", (Object)"8.2.1", (Object)"8.2.2", (Object)"8.2.3", (Object)"8.2.4", (Object)"8.3.0", (Object[])new String[0]);
    private static final String LOG_PREFIX = "[KEY-FIXER] ";
    private final QueryDslAccessor queryDslAccessor;
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18nFactory;
    private final UpgradeVersionHistoryReader upgradeVersionHistoryReader;
    private final AuditingManager auditingManager;
    private final EventPublisher eventPublisher;
    private final JqlQueryParser jqlQueryParser;

    public UntranslatedKeyFixer(QueryDslAccessor queryDslAccessor, ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18nFactory, UpgradeVersionHistoryReader upgradeVersionHistoryReader, AuditingManager auditingManager, JqlQueryParser jqlQueryParser, EventPublisher eventPublisher) {
        this.queryDslAccessor = queryDslAccessor;
        this.applicationProperties = applicationProperties;
        this.i18nFactory = i18nFactory;
        this.upgradeVersionHistoryReader = upgradeVersionHistoryReader;
        this.auditingManager = auditingManager;
        this.eventPublisher = eventPublisher;
        this.jqlQueryParser = jqlQueryParser;
    }

    boolean isKeyFixerEnabled() {
        String isDisabledString = this.applicationProperties.getString(APPLICATION_PROPERTY_KEY_FIXER_DISABLED);
        return isDisabledString == null || Boolean.valueOf(isDisabledString) == false;
    }

    boolean hasAffectedVersion() {
        return this.upgradeVersionHistoryReader.getAllUpgradeVersionHistory().stream().flatMap(upgradeVersionHistoryItem -> Stream.of(upgradeVersionHistoryItem.getOriginalVersion(), upgradeVersionHistoryItem.getTargetVersion())).filter(Objects::nonNull).map(UntranslatedKeyFixer::trimToSimpleVersion).anyMatch(AFFECTED_VERSIONS::contains);
    }

    static String trimToSimpleVersion(String origVersion) {
        Matcher matcher = VERSION_REGEX.matcher(origVersion);
        return matcher.matches() ? matcher.group(1) : origVersion;
    }

    private void disableKeyFixer() {
        String newPropertyValue = Boolean.TRUE.toString();
        log.info("[KEY-FIXER] Setting application property: {} to {}", (Object)APPLICATION_PROPERTY_KEY_FIXER_DISABLED, (Object)newPropertyValue);
        this.applicationProperties.setString(APPLICATION_PROPERTY_KEY_FIXER_DISABLED, newPropertyValue);
        log.info("[KEY-FIXER] Application property: {}={}", (Object)APPLICATION_PROPERTY_KEY_FIXER_DISABLED, (Object)this.applicationProperties.getString(APPLICATION_PROPERTY_KEY_FIXER_DISABLED));
    }

    public void runOnce() {
        try {
            if (!this.isKeyFixerEnabled()) {
                log.info("[KEY-FIXER] Not running untranslated key fixer as it was already run, application property: {}={}", (Object)APPLICATION_PROPERTY_KEY_FIXER_DISABLED, (Object)this.applicationProperties.getString(APPLICATION_PROPERTY_KEY_FIXER_DISABLED));
                return;
            }
            this.disableKeyFixer();
            if (!this.hasAffectedVersion()) {
                log.info("[KEY-FIXER] Not running untranslated key fixer as no affected Jira version [{}] has been installed.", (Object)Joiner.on((String)", ").join(AFFECTED_VERSIONS));
                return;
            }
            log.info("[KEY-FIXER] Running untranslated key fixer...");
            boolean updatesOccurred = false;
            List<String> brokenCustomFieldsKeys = this.tryFixCustomFields();
            updatesOccurred |= !brokenCustomFieldsKeys.isEmpty();
            updatesOccurred |= this.tryFixIssueType();
            updatesOccurred |= this.tryFixFieldConfigScheme();
            updatesOccurred |= this.tryFixFieldConfiguration();
            updatesOccurred |= this.tryFixFieldLayoutItem();
            updatesOccurred |= this.tryFixProjectRole();
            if (updatesOccurred |= this.tryFixSearchRequest(brokenCustomFieldsKeys)) {
                this.clearAllRelatedCaches();
            }
            log.info("[KEY-FIXER] Untranslated key fixer finished.");
        }
        catch (Throwable e) {
            log.error("[KEY-FIXER] Error occurred when trying to run untranslated key fixer, ignoring it and not attempting any further key fixes.", e);
        }
    }

    void clearAllRelatedCaches() {
        try {
            log.info("[KEY-FIXER] Resetting all related caches.");
            this.eventPublisher.publish((Object)ClearCacheEvent.INSTANCE);
        }
        catch (Exception e) {
            log.error("[KEY-FIXER] Error when clearing all related caches: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    List<String> tryFixCustomFields() {
        ArrayList<String> result = new ArrayList<String>();
        log.info("[KEY-FIXER] Triggering customfield fixer.");
        try {
            List customFieldDTOS = this.queryDslAccessor.withNewConnection().executeQuery(callback -> ((SQLQuery)callback.newSqlQuery().select((Expression)QCustomField.CUSTOM_FIELD).from((Expression)QCustomField.CUSTOM_FIELD)).fetch());
            AtomicInteger problemCounter = new AtomicInteger(0);
            AtomicInteger fixedCounter = new AtomicInteger(0);
            I18nHelper i18nHelper = this.i18nFactory.getInstance(this.applicationProperties.getDefaultLocale());
            for (CustomFieldDTO customFieldDTO : customFieldDTOS) {
                Long id = customFieldDTO.getId();
                if (id == null) continue;
                String nameOrKey = customFieldDTO.getName();
                String descriptionOrKey = customFieldDTO.getDescription();
                String retranslatedName = i18nHelper.getText(nameOrKey);
                String retranslatedDescription = i18nHelper.getText(descriptionOrKey);
                if (StringUtils.equals((CharSequence)retranslatedName, (CharSequence)nameOrKey) && StringUtils.equals((CharSequence)retranslatedDescription, (CharSequence)descriptionOrKey)) continue;
                problemCounter.incrementAndGet();
                result.add(nameOrKey);
                log.warn("[KEY-FIXER] Fixing customfield [name, description] id: {} from [{}, {}] to [{}, {}]...", new Object[]{id, nameOrKey, descriptionOrKey, retranslatedName, retranslatedDescription});
                try {
                    this.queryDslAccessor.withNewConnection().execute(connection -> connection.update((RelationalPath<?>)QCustomField.CUSTOM_FIELD).set((Path)QCustomField.CUSTOM_FIELD.name, (Object)retranslatedName).set((Path)QCustomField.CUSTOM_FIELD.description, (Object)retranslatedDescription).where((Predicate)QCustomField.CUSTOM_FIELD.id.eq((Object)id)).execute());
                    fixedCounter.incrementAndGet();
                    log.info("[KEY-FIXER] Fixing customfield id: {} done.", (Object)id);
                    this.auditCustomField(customFieldDTO, retranslatedName, retranslatedDescription);
                }
                catch (Exception e) {
                    log.error("[KEY-FIXER] Error occurred when fixing customfield id: {} : {}.", new Object[]{id, e.getMessage(), e});
                }
            }
            log.info("[KEY-FIXER] Fixing customfield done: {}/{}/{} [found problems/fixed problems/total]", new Object[]{problemCounter.get(), fixedCounter.get(), customFieldDTOS.size()});
            return result;
        }
        catch (Throwable e) {
            log.error("[KEY-FIXER] Error occurred when trying to fix customfield, ignore it and continue.", e);
            return result;
        }
    }

    private void auditCustomField(CustomFieldDTO originalCustomFieldDTO, String retranslatedName, String retranslatedDescription) {
        RecordRequest recordRequest = CustomFieldHandler.onCustomFieldUpdatedEvent(UntranslatedKeyFixer.createCustomFieldDetailsFrom(originalCustomFieldDTO.getId(), originalCustomFieldDTO.getName(), originalCustomFieldDTO.getDescription()), UntranslatedKeyFixer.createCustomFieldDetailsFrom(originalCustomFieldDTO.getId(), retranslatedName, retranslatedDescription)).withDescription("Updated by untranslated key fixer.");
        this.auditingManager.store(recordRequest);
    }

    private static CustomFieldDetails createCustomFieldDetailsFrom(final Long id, final String name, final String description) {
        return new CustomFieldDetails(){

            public String getId() {
                return "customfield_" + id;
            }

            public String getFieldTypeName() {
                return null;
            }

            public Long getIdAsLong() {
                return id;
            }

            public String getUntranslatedName() {
                return name;
            }

            public String getUntranslatedDescription() {
                return description;
            }
        };
    }

    boolean tryFixIssueType() {
        log.info("[KEY-FIXER] Triggering issuetype fixer.");
        try {
            List issueTypeDTOS = this.queryDslAccessor.withNewConnection().executeQuery(callback -> ((SQLQuery)callback.newSqlQuery().select((Expression)QIssueType.ISSUE_TYPE).from((Expression)QIssueType.ISSUE_TYPE)).fetch());
            AtomicInteger problemCounter = new AtomicInteger(0);
            AtomicInteger fixedCounter = new AtomicInteger(0);
            I18nHelper i18nHelper = this.i18nFactory.getInstance(this.applicationProperties.getDefaultLocale());
            for (IssueTypeDTO issueTypeDTO : issueTypeDTOS) {
                String id = issueTypeDTO.getId();
                if (id == null) continue;
                String nameOrKey = issueTypeDTO.getName();
                String descriptionOrKey = issueTypeDTO.getDescription();
                String retranslatedName = i18nHelper.getText(nameOrKey);
                String retranslatedDescription = i18nHelper.getText(descriptionOrKey);
                if (StringUtils.equals((CharSequence)retranslatedName, (CharSequence)nameOrKey) && StringUtils.equals((CharSequence)retranslatedDescription, (CharSequence)descriptionOrKey)) continue;
                problemCounter.incrementAndGet();
                log.warn("[KEY-FIXER] Fixing issuetype [name, description] id: {} from [{}, {}] to [{}, {}]...", new Object[]{id, nameOrKey, descriptionOrKey, retranslatedName, retranslatedDescription});
                try {
                    this.queryDslAccessor.withNewConnection().execute(connection -> connection.update((RelationalPath<?>)QIssueType.ISSUE_TYPE).set((Path)QIssueType.ISSUE_TYPE.name, (Object)retranslatedName).set((Path)QIssueType.ISSUE_TYPE.description, (Object)retranslatedDescription).where((Predicate)QIssueType.ISSUE_TYPE.id.eq((Object)id)).execute());
                    fixedCounter.incrementAndGet();
                    log.info("[KEY-FIXER] Fixing issuetype id: {} done.", (Object)id);
                }
                catch (Exception e) {
                    log.error("[KEY-FIXER] Error occurred when fixing issuetype id: {} : {}.", new Object[]{id, e.getMessage(), e});
                }
            }
            log.info("[KEY-FIXER] Fixing issuetype done: {}/{}/{} [found problems/fixed problems/total]", new Object[]{problemCounter.get(), fixedCounter.get(), issueTypeDTOS.size()});
            return fixedCounter.get() > 0;
        }
        catch (Throwable e) {
            log.error("[KEY-FIXER] Error occurred when trying to fix issuetype, ignore it and continue.", e);
            return true;
        }
    }

    boolean tryFixFieldConfigScheme() {
        log.info("[KEY-FIXER] Triggering fieldconfigscheme fixer.");
        try {
            List fieldConfigSchemeDTOS = this.queryDslAccessor.withNewConnection().executeQuery(callback -> ((SQLQuery)callback.newSqlQuery().select((Expression)QFieldConfigScheme.FIELD_CONFIG_SCHEME).from((Expression)QFieldConfigScheme.FIELD_CONFIG_SCHEME)).fetch());
            AtomicInteger problemCounter = new AtomicInteger(0);
            AtomicInteger fixedCounter = new AtomicInteger(0);
            I18nHelper i18nHelper = this.i18nFactory.getInstance(this.applicationProperties.getDefaultLocale());
            for (FieldConfigSchemeDTO fieldConfigSchemeDTO : fieldConfigSchemeDTOS) {
                String nameWithPartialKey;
                String retranslatedName;
                Long id = fieldConfigSchemeDTO.getId();
                if (id == null || StringUtils.equals((CharSequence)(retranslatedName = UntranslatedKeyFixer.fixTextWithKeys(nameWithPartialKey = fieldConfigSchemeDTO.getName(), i18nHelper)), (CharSequence)nameWithPartialKey)) continue;
                problemCounter.incrementAndGet();
                log.warn("[KEY-FIXER] Fixing fieldconfigscheme [name] id: {} from [{}] to [{}]...", new Object[]{id, nameWithPartialKey, retranslatedName});
                try {
                    this.queryDslAccessor.withNewConnection().execute(connection -> connection.update((RelationalPath<?>)QFieldConfigScheme.FIELD_CONFIG_SCHEME).set((Path)QFieldConfigScheme.FIELD_CONFIG_SCHEME.name, (Object)retranslatedName).where((Predicate)QFieldConfigScheme.FIELD_CONFIG_SCHEME.id.eq((Object)id)).execute());
                    fixedCounter.incrementAndGet();
                    log.info("[KEY-FIXER] Fixing fieldconfigscheme id: {} done.", (Object)id);
                }
                catch (Exception e) {
                    log.error("[KEY-FIXER] Error occurred when fixing fieldconfigscheme id: {} : {}.", new Object[]{id, e.getMessage(), e});
                }
            }
            log.info("[KEY-FIXER] Fixing fieldconfigscheme done: {}/{}/{} [found problems/fixed problems/total]", new Object[]{problemCounter.get(), fixedCounter.get(), fieldConfigSchemeDTOS.size()});
            return fixedCounter.get() > 0;
        }
        catch (Throwable e) {
            log.error("[KEY-FIXER] Error occurred when trying to fix fieldconfigscheme, ignore it and continue.", e);
            return true;
        }
    }

    boolean tryFixFieldConfiguration() {
        log.info("[KEY-FIXER] Triggering fieldconfiguration fixer.");
        try {
            List fieldConfigurationDTOS = this.queryDslAccessor.withNewConnection().executeQuery(callback -> ((SQLQuery)callback.newSqlQuery().select((Expression)QFieldConfiguration.FIELD_CONFIGURATION).from((Expression)QFieldConfiguration.FIELD_CONFIGURATION)).fetch());
            AtomicInteger problemCounter = new AtomicInteger(0);
            AtomicInteger fixedCounter = new AtomicInteger(0);
            I18nHelper i18nHelper = this.i18nFactory.getInstance(this.applicationProperties.getDefaultLocale());
            for (FieldConfigurationDTO fieldConfigurationDTO : fieldConfigurationDTOS) {
                String nameWithPartialKey;
                String retranslatedName;
                Long id = fieldConfigurationDTO.getId();
                if (id == null || StringUtils.equals((CharSequence)(retranslatedName = UntranslatedKeyFixer.fixTextWithKeys(nameWithPartialKey = fieldConfigurationDTO.getName(), i18nHelper)), (CharSequence)nameWithPartialKey)) continue;
                problemCounter.incrementAndGet();
                log.warn("[KEY-FIXER] Fixing fieldconfiguration [name] id: {} from [{}] to [{}]...", new Object[]{id, nameWithPartialKey, retranslatedName});
                try {
                    this.queryDslAccessor.withNewConnection().execute(connection -> connection.update((RelationalPath<?>)QFieldConfiguration.FIELD_CONFIGURATION).set((Path)QFieldConfiguration.FIELD_CONFIGURATION.name, (Object)retranslatedName).where((Predicate)QFieldConfiguration.FIELD_CONFIGURATION.id.eq((Object)id)).execute());
                    fixedCounter.incrementAndGet();
                    log.info("[KEY-FIXER] Fixing fieldconfiguration id: {} done.", (Object)id);
                }
                catch (Exception e) {
                    log.error("[KEY-FIXER] Error occurred when fixing fieldconfiguration id: {} : {}.", new Object[]{id, e.getMessage(), e});
                }
            }
            log.info("[KEY-FIXER] Fixing fieldconfiguration done: {}/{}/{} [found problems/fixed problems/total]", new Object[]{problemCounter.get(), fixedCounter.get(), fieldConfigurationDTOS.size()});
            return fixedCounter.get() > 0;
        }
        catch (Throwable e) {
            log.error("[KEY-FIXER] Error occurred when trying to fix fieldconfiguration, ignore it and continue.", e);
            return true;
        }
    }

    boolean tryFixFieldLayoutItem() {
        log.info("[KEY-FIXER] Triggering fieldlayoutitem fixer.");
        try {
            List fieldLayoutItemDTOS = this.queryDslAccessor.withNewConnection().executeQuery(callback -> ((SQLQuery)callback.newSqlQuery().select((Expression)QFieldLayoutItem.FIELD_LAYOUT_ITEM).from((Expression)QFieldLayoutItem.FIELD_LAYOUT_ITEM)).fetch());
            AtomicInteger problemCounter = new AtomicInteger(0);
            AtomicInteger fixedCounter = new AtomicInteger(0);
            I18nHelper i18nHelper = this.i18nFactory.getInstance(this.applicationProperties.getDefaultLocale());
            for (FieldLayoutItemDTO fieldLayoutItemDTO : fieldLayoutItemDTOS) {
                String descriptionOrKey;
                String retranslatedDescription;
                Long id = fieldLayoutItemDTO.getId();
                if (id == null || StringUtils.equals((CharSequence)(retranslatedDescription = i18nHelper.getText(descriptionOrKey = fieldLayoutItemDTO.getDescription())), (CharSequence)descriptionOrKey)) continue;
                problemCounter.incrementAndGet();
                log.warn("[KEY-FIXER] Fixing fieldlayoutitem [description] id: {} from [{}] to [{}]...", new Object[]{id, descriptionOrKey, retranslatedDescription});
                try {
                    this.queryDslAccessor.withNewConnection().execute(connection -> connection.update((RelationalPath<?>)QFieldLayoutItem.FIELD_LAYOUT_ITEM).set((Path)QFieldLayoutItem.FIELD_LAYOUT_ITEM.description, (Object)retranslatedDescription).where((Predicate)QFieldLayoutItem.FIELD_LAYOUT_ITEM.id.eq((Object)id)).execute());
                    fixedCounter.incrementAndGet();
                    log.info("[KEY-FIXER] Fixing fieldlayoutitem id: {} done.", (Object)id);
                }
                catch (Exception e) {
                    log.error("[KEY-FIXER] Error occurred when fixing fieldlayoutitem id: {} : {}.", new Object[]{id, e.getMessage(), e});
                }
            }
            log.info("[KEY-FIXER] Fixing fieldlayoutitem done: {}/{}/{} [found problems/fixed problems/total]", new Object[]{problemCounter.get(), fixedCounter.get(), fieldLayoutItemDTOS.size()});
            return fixedCounter.get() > 0;
        }
        catch (Throwable e) {
            log.error("[KEY-FIXER] Error occurred when trying to fix fieldlayoutitem, ignore it and continue.", e);
            return true;
        }
    }

    boolean tryFixProjectRole() {
        log.info("[KEY-FIXER] Triggering projectrole fixer.");
        try {
            List projectRoleDTOS = this.queryDslAccessor.withNewConnection().executeQuery(callback -> ((SQLQuery)callback.newSqlQuery().select((Expression)QProjectRole.PROJECT_ROLE).from((Expression)QProjectRole.PROJECT_ROLE)).fetch());
            AtomicInteger problemCounter = new AtomicInteger(0);
            AtomicInteger fixedCounter = new AtomicInteger(0);
            I18nHelper i18nHelper = this.i18nFactory.getInstance(this.applicationProperties.getDefaultLocale());
            for (ProjectRoleDTO projectRoleDTO : projectRoleDTOS) {
                Long id = projectRoleDTO.getId();
                if (id == null) continue;
                String nameOrKey = projectRoleDTO.getName();
                String descriptionOrKey = projectRoleDTO.getDescription();
                String retranslatedName = i18nHelper.getText(nameOrKey);
                String retranslatedDescription = i18nHelper.getText(descriptionOrKey);
                if (StringUtils.equals((CharSequence)retranslatedName, (CharSequence)nameOrKey) && StringUtils.equals((CharSequence)retranslatedDescription, (CharSequence)descriptionOrKey)) continue;
                problemCounter.incrementAndGet();
                log.warn("[KEY-FIXER] Fixing projectrole [name, description] id: {} from [{}, {}] to [{}, {}]...", new Object[]{id, nameOrKey, descriptionOrKey, retranslatedName, retranslatedDescription});
                try {
                    this.queryDslAccessor.withNewConnection().execute(connection -> connection.update((RelationalPath<?>)QProjectRole.PROJECT_ROLE).set((Path)QProjectRole.PROJECT_ROLE.name, (Object)retranslatedName).set((Path)QProjectRole.PROJECT_ROLE.description, (Object)retranslatedDescription).where((Predicate)QProjectRole.PROJECT_ROLE.id.eq((Object)id)).execute());
                    fixedCounter.incrementAndGet();
                    log.info("[KEY-FIXER] Fixing projectrole id: {} done.", (Object)id);
                }
                catch (Exception e) {
                    log.error("[KEY-FIXER] Error occurred when fixing projectrole id: {} : {}.", new Object[]{id, e.getMessage(), e});
                }
            }
            log.info("[KEY-FIXER] Fixing projectrole done: {}/{}/{} [found problems/fixed problems/total]", new Object[]{problemCounter.get(), fixedCounter.get(), projectRoleDTOS.size()});
            return fixedCounter.get() > 0;
        }
        catch (Throwable e) {
            log.error("[KEY-FIXER] Error occurred when trying to fix projectrole, ignore it and continue.", e);
            return true;
        }
    }

    boolean tryFixSearchRequest(List<String> brokenCustomFieldKeys) {
        log.info("[KEY-FIXER] Triggering searchrequest fixer.");
        try {
            List searchRequestDTOS = this.queryDslAccessor.withNewConnection().executeQuery(callback -> ((SQLQuery)callback.newSqlQuery().select((Expression)QSearchRequest.SEARCH_REQUEST).from((Expression)QSearchRequest.SEARCH_REQUEST)).fetch());
            AtomicInteger problemCounter = new AtomicInteger(0);
            AtomicInteger fixedCounter = new AtomicInteger(0);
            I18nHelper i18nHelper = this.i18nFactory.getInstance(this.applicationProperties.getDefaultLocale());
            for (SearchRequestDTO searchRequestDTO : searchRequestDTOS) {
                String requestWithKeys;
                String retranslatedRequest;
                Long id = searchRequestDTO.getId();
                if (id == null || StringUtils.equals((CharSequence)(retranslatedRequest = UntranslatedKeyFixer.fixQueryWithKeysAndThenWithBrokenKeysList(requestWithKeys = searchRequestDTO.getRequest(), brokenCustomFieldKeys, i18nHelper)), (CharSequence)requestWithKeys)) continue;
                problemCounter.incrementAndGet();
                log.warn("[KEY-FIXER] Fixing searchrequest [reqcontent] id: {} from [{}] to [{}]...", new Object[]{id, requestWithKeys, retranslatedRequest});
                try {
                    this.jqlQueryParser.parseQuery(retranslatedRequest);
                }
                catch (JqlParseException e) {
                    log.warn("[KEY-FIXER] Can not parse new search request: {}. Skipping translating: {}", (Object)retranslatedRequest, (Object)requestWithKeys);
                    continue;
                }
                try {
                    this.queryDslAccessor.withNewConnection().execute(connection -> connection.update((RelationalPath<?>)QSearchRequest.SEARCH_REQUEST).set((Path)QSearchRequest.SEARCH_REQUEST.request, (Object)retranslatedRequest).where((Predicate)QSearchRequest.SEARCH_REQUEST.id.eq((Object)id)).execute());
                    fixedCounter.incrementAndGet();
                    log.info("[KEY-FIXER] Fixing searchrequest id: {} done.", (Object)id);
                }
                catch (Exception e) {
                    log.error("[KEY-FIXER] Error occurred when fixing searchrequest id: {} : {}.", new Object[]{id, e.getMessage(), e});
                }
            }
            log.info("[KEY-FIXER] Fixing searchrequest done: {}/{}/{} [found problems/fixed problems/total]", new Object[]{problemCounter.get(), fixedCounter.get(), searchRequestDTOS.size()});
            return fixedCounter.get() > 0;
        }
        catch (Throwable e) {
            log.error("[KEY-FIXER] Error occurred when trying to fix searchrequest, ignore it and continue.", e);
            return true;
        }
    }

    static String fixQueryWithKeysAndThenWithBrokenKeysList(String query, List<String> brokenKeys, I18nHelper i18nHelper) {
        String retranslated1 = UntranslatedKeyFixer.fixQueryWithKeys(query, i18nHelper);
        return UntranslatedKeyFixer.fixQueryWithBrokenKeysList(retranslated1, brokenKeys, i18nHelper);
    }

    static String fixQueryWithKeys(String query, I18nHelper i18nHelper) {
        if (query == null || query.trim().isEmpty()) {
            return query;
        }
        Iterable tokens = Splitter.onPattern((String)"\\s+").trimResults().omitEmptyStrings().split((CharSequence)query);
        ArrayList<String> brokenKeys = new ArrayList<String>();
        for (String token : tokens) {
            String newToken;
            if (StringUtils.equals((CharSequence)token, (CharSequence)(newToken = i18nHelper.getText(token)))) continue;
            brokenKeys.add(token);
        }
        if (brokenKeys.isEmpty()) {
            return query;
        }
        return UntranslatedKeyFixer.fixQueryWithBrokenKeysList(query, brokenKeys, i18nHelper);
    }

    static String fixQueryWithBrokenKeysList(String query, List<String> brokenKeys, I18nHelper i18nHelper) {
        if (query == null || query.trim().isEmpty() || brokenKeys.isEmpty()) {
            return query;
        }
        String newText = query;
        boolean retranslated = false;
        for (String brokenKey : UntranslatedKeyFixer.sortByLengthDesc(brokenKeys)) {
            String retranslatedBrokenKey;
            if (!newText.contains(brokenKey) || StringUtils.equals((CharSequence)brokenKey, (CharSequence)(retranslatedBrokenKey = i18nHelper.getText(brokenKey)))) continue;
            if (StringUtils.containsWhitespace((CharSequence)retranslatedBrokenKey)) {
                String brokenKeyEscaped = Pattern.quote(brokenKey);
                String regexForOptionallyQuotedKey = String.format("(%s)|(%s)|(%s)", brokenKeyEscaped, UntranslatedKeyFixer.quote(brokenKeyEscaped), UntranslatedKeyFixer.doubleQuote(brokenKeyEscaped));
                newText = newText.replaceAll(regexForOptionallyQuotedKey, UntranslatedKeyFixer.doubleQuote(retranslatedBrokenKey));
            } else {
                newText = newText.replace(brokenKey, retranslatedBrokenKey);
            }
            retranslated = true;
        }
        if (retranslated) {
            return newText;
        }
        return query;
    }

    static String fixTextWithKeys(String text, I18nHelper i18nHelper) {
        if (text == null || text.trim().isEmpty()) {
            return text;
        }
        Iterable tokens = Splitter.onPattern((String)"\\s+").trimResults().omitEmptyStrings().split((CharSequence)text);
        ArrayList<String> brokenKeys = new ArrayList<String>();
        for (String token : tokens) {
            String newToken;
            if (StringUtils.equals((CharSequence)token, (CharSequence)(newToken = i18nHelper.getText(token)))) continue;
            brokenKeys.add(token);
        }
        if (brokenKeys.isEmpty()) {
            return text;
        }
        return UntranslatedKeyFixer.fixTextWithBrokenKeysList(text, brokenKeys, i18nHelper);
    }

    static String fixTextWithBrokenKeysList(String text, List<String> brokenKeys, I18nHelper i18nHelper) {
        if (text == null || text.trim().isEmpty() || brokenKeys.isEmpty()) {
            return text;
        }
        String newText = text;
        for (String brokenKey : UntranslatedKeyFixer.sortByLengthDesc(brokenKeys)) {
            String retranslatedBrokenKey;
            if (!newText.contains(brokenKey) || StringUtils.equals((CharSequence)brokenKey, (CharSequence)(retranslatedBrokenKey = i18nHelper.getText(brokenKey)))) continue;
            newText = newText.replace(brokenKey, retranslatedBrokenKey);
        }
        return newText;
    }

    private static List<String> sortByLengthDesc(List<String> list) {
        return list.stream().sorted(Comparator.comparingInt(String::length).reversed()).collect(Collectors.toList());
    }

    private static String quote(String s) {
        return String.format("'%s'", s);
    }

    private static String doubleQuote(String s) {
        return String.format("\"%s\"", s);
    }
}

