/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.index.request.ReindexRequest;
import com.atlassian.jira.index.request.ReindexRequestBase;
import com.atlassian.jira.index.request.ReindexRequestManager;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.ReindexStatus;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeIndexManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeIndexManager.class);
    private static final String REINDEX_ALLOWED_SYSTEM_PROPERTY = "upgrade.reindex.allowed";
    private final ReindexRequestManager reindexRequestManager;
    private final ReindexMessageManager reindexMessageManager;
    private final ApplicationProperties applicationProperties;
    private final JiraProperties jiraSystemProperties;

    public UpgradeIndexManager(ReindexRequestManager reindexRequestManager, ReindexMessageManager reindexMessageManager, ApplicationProperties applicationProperties, JiraProperties jiraSystemProperties) {
        this.reindexRequestManager = reindexRequestManager;
        this.reindexMessageManager = reindexMessageManager;
        this.applicationProperties = applicationProperties;
        this.jiraSystemProperties = jiraSystemProperties;
    }

    public boolean runReindexIfNeededAndAllowed(Set<ReindexRequestType> allowedReindexRequestTypes) {
        boolean immediateReindexesRequested = this.reindexRequestManager.isReindexRequested(EnumSet.of(ReindexRequestType.IMMEDIATE));
        if (allowedReindexRequestTypes.isEmpty()) {
            if (immediateReindexesRequested) {
                LOGGER.info("There is an immediate reindex request but a reindex is not being run. Sending a message to the admin screen for admins to initiate a reindex");
                this.reindexMessageManager.pushRawMessage(null, "admin.upgrade.reindex.deferred");
                return true;
            }
            LOGGER.info("Reindexing is not allowed after this upgrade and there is no immediate reindex requests");
            return true;
        }
        boolean reindexesRequested = this.reindexRequestManager.isReindexRequested(allowedReindexRequestTypes);
        if (reindexesRequested) {
            if (this.isReindexingAllowed()) {
                return this.executeReindex(allowedReindexRequestTypes, immediateReindexesRequested);
            }
            Iterable pendingReindexRequests = this.reindexRequestManager.getPendingReindexRequests(allowedReindexRequestTypes);
            List requestedReindexTypes = StreamSupport.stream(pendingReindexRequests.spliterator(), false).map(ReindexRequestBase::getType).collect(Collectors.toList());
            LOGGER.info("There is a reindex request '{}' but a reindex is not being run. Sending a message to the admin screen for admins to initiate a reindex and clearing pending reindex requests of types: {}", allowedReindexRequestTypes, requestedReindexTypes);
            this.reindexMessageManager.pushRawMessage(null, "admin.upgrade.reindex.deferred");
            this.reindexRequestManager.transitionStatus(pendingReindexRequests, ReindexStatus.FAILED);
            return true;
        }
        LOGGER.info("There are no reindex requests of type {} so none will be run", allowedReindexRequestTypes);
        return true;
    }

    private boolean isReindexingAllowed() {
        boolean reindexingAllowed;
        this.checkReindexConfigurationConsistency();
        boolean reindexingAllowedSys = this.getReindexingAllowedSystemProperty();
        boolean reindexingAllowedApp = this.getReindexingAllowedApplicationProperty();
        boolean bl = reindexingAllowed = reindexingAllowedSys && reindexingAllowedApp;
        if (!reindexingAllowed) {
            LOGGER.info("Reindexing is not allowed because: " + UpgradeIndexManager.getReindexingDisallowedCauseMessage(reindexingAllowedSys, reindexingAllowedApp));
        }
        return reindexingAllowed;
    }

    private boolean getReindexingAllowedApplicationProperty() {
        return PropertiesUtil.getBooleanProperty((ApplicationProperties)this.applicationProperties, (String)REINDEX_ALLOWED_SYSTEM_PROPERTY, (boolean)true);
    }

    private boolean getReindexingAllowedSystemProperty() {
        return Boolean.valueOf(this.jiraSystemProperties.getProperty(REINDEX_ALLOWED_SYSTEM_PROPERTY, "true"));
    }

    private void checkReindexConfigurationConsistency() {
        boolean reindexingAllowedApp;
        boolean reindexingAllowedSys;
        if (this.jiraSystemProperties.getProperties().containsKey(REINDEX_ALLOWED_SYSTEM_PROPERTY) && this.applicationProperties.exists(REINDEX_ALLOWED_SYSTEM_PROPERTY) && (reindexingAllowedSys = this.getReindexingAllowedSystemProperty()) ^ (reindexingAllowedApp = this.getReindexingAllowedApplicationProperty())) {
            LOGGER.warn("Detected inconsistent settings for auto reindexing. System property {}={}, Application property {}={}. Overriding with 'false' value.", new Object[]{REINDEX_ALLOWED_SYSTEM_PROPERTY, reindexingAllowedSys, REINDEX_ALLOWED_SYSTEM_PROPERTY, reindexingAllowedApp});
        }
    }

    private static String getReindexingDisallowedCauseMessage(boolean reindexingAllowedSys, boolean reindexingAllowedApp) {
        Preconditions.checkArgument((!reindexingAllowedApp || !reindexingAllowedSys ? 1 : 0) != 0, (Object)"Never call this with both arguments true");
        String propertyInfo = "";
        if (!reindexingAllowedSys) {
            propertyInfo = propertyInfo + "System Property '" + REINDEX_ALLOWED_SYSTEM_PROPERTY + "' is set to 'false'. ";
        }
        if (!reindexingAllowedApp) {
            propertyInfo = propertyInfo + "Application Property '" + REINDEX_ALLOWED_SYSTEM_PROPERTY + "' is set to 'false'. ";
        }
        return propertyInfo;
    }

    private boolean executeReindex(Set<ReindexRequestType> reindexRequestTypes, boolean immediateReindexesRequested) {
        LOGGER.debug("Reindex all data if indexing is turned on.");
        if (immediateReindexesRequested && reindexRequestTypes.contains(ReindexRequestType.IMMEDIATE)) {
            return this.executeImmediateReindex(reindexRequestTypes);
        }
        return this.executeDelayedReindex(reindexRequestTypes);
    }

    private boolean executeImmediateReindex(Set<ReindexRequestType> reindexRequestTypes) {
        LOGGER.info("Requesting immediate reindex");
        Set reindexRequests = this.reindexRequestManager.processPendingRequests(true, reindexRequestTypes, false);
        for (ReindexRequest reindexRequest : reindexRequests) {
            if (reindexRequest.getStatus() != ReindexStatus.FAILED) continue;
            return false;
        }
        return true;
    }

    private boolean executeDelayedReindex(Set<ReindexRequestType> reindexRequestTypes) {
        this.reindexRequestManager.processPendingRequests(false, reindexRequestTypes, true);
        LOGGER.info("Delayed reindex has been requested.");
        return true;
    }
}

