/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QUpgradeHistory;
import com.atlassian.jira.model.querydsl.QUpgradeTaskHistory;
import com.atlassian.jira.model.querydsl.QUpgradeTaskHistoryAuditLog;
import com.atlassian.jira.model.querydsl.UpgradeTaskHistoryDTO;
import com.atlassian.upgrade.core.dao.UpgradeTaskHistory;
import com.atlassian.upgrade.core.dao.UpgradeTaskHistoryDao;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.joda.time.DateTimeUtils;

public class UpgradeTaskHistoryDaoImpl
implements UpgradeTaskHistoryDao {
    private static final String TASK_ACTION_UPGRADE = "upgrade";
    private final QueryDslAccessor queryDslAccessor;

    public UpgradeTaskHistoryDaoImpl(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    public int createUpgradeTaskHistory(UpgradeTaskHistory upgradeTaskHistory) {
        long id = this.queryDslAccessor.withNewConnection().executeQuery(dbConnection -> dbConnection.insert(QUpgradeTaskHistory.UPGRADE_TASK_HISTORY).set((Path)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.buildNumber, (Object)upgradeTaskHistory.getBuildNumber()).set((Path)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.status, upgradeTaskHistory.getStatus().toString()).set((Path)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.upgradeTaskFactoryKey, upgradeTaskHistory.getUpgradeTaskFactoryKey()).set((Path)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.upgradeType, upgradeTaskHistory.getUpgradeType().toString()).executeWithId());
        return (int)id;
    }

    public void updateStatus(int id, UpgradeTaskHistory.Status status) {
        this.queryDslAccessor.withNewConnection().execute(dbConnection -> {
            long rowsUpdated = dbConnection.update((RelationalPath<?>)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY).set((Path)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.status, (Object)status.toString()).where((Predicate)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.id.eq((Object)id)).execute();
            if (status != UpgradeTaskHistory.Status.IN_PROGRESS && rowsUpdated > 0L) {
                Timestamp time = new Timestamp(DateTimeUtils.currentTimeMillis());
                UpgradeTaskHistoryDTO taskHistory = (UpgradeTaskHistoryDTO)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY).from((Expression)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY)).where((Predicate)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.id.eq((Object)id))).fetchOne();
                dbConnection.insert(QUpgradeTaskHistoryAuditLog.UPGRADE_TASK_HISTORY_AUDIT_LOG).set((Path)QUpgradeTaskHistoryAuditLog.UPGRADE_TASK_HISTORY_AUDIT_LOG.buildNumber, taskHistory.getBuildNumber()).set((Path)QUpgradeTaskHistoryAuditLog.UPGRADE_TASK_HISTORY_AUDIT_LOG.status, taskHistory.getStatus()).set((Path)QUpgradeTaskHistoryAuditLog.UPGRADE_TASK_HISTORY_AUDIT_LOG.upgradeTaskFactoryKey, taskHistory.getUpgradeTaskFactoryKey()).set((Path)QUpgradeTaskHistoryAuditLog.UPGRADE_TASK_HISTORY_AUDIT_LOG.upgradeType, taskHistory.getUpgradeType()).set((Path)QUpgradeTaskHistoryAuditLog.UPGRADE_TASK_HISTORY_AUDIT_LOG.timeperformed, time).set((Path)QUpgradeTaskHistoryAuditLog.UPGRADE_TASK_HISTORY_AUDIT_LOG.action, TASK_ACTION_UPGRADE).executeWithId();
            }
        });
    }

    public Optional<Integer> getIdByBuildNumber(String upgradeFactoryKey, int buildNumber) {
        return Optional.ofNullable(this.queryDslAccessor.withNewConnection().executeQuery(dbConnection -> (Long)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)SQLExpressions.select(QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.id)).from((Expression)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY)).where((Predicate)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.upgradeTaskFactoryKey.eq((Object)upgradeFactoryKey).and((Predicate)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.buildNumber.eq((Object)buildNumber)))).fetchOne())).map(Long::intValue);
    }

    public int getDatabaseBuildNumber(String upgradeFactoryKey) {
        List results = this.queryDslAccessor.withNewConnection().executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY).from((Expression)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY)).where((Predicate)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.upgradeTaskFactoryKey.eq((Object)upgradeFactoryKey).and((Predicate)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.status.eq((Object)UpgradeTaskHistory.Status.COMPLETED.name())))).fetch());
        OptionalInt optionalBuildNumber = results.stream().mapToInt(UpgradeTaskHistoryDTO::getBuildNumber).max();
        if (optionalBuildNumber.isPresent()) {
            return optionalBuildNumber.getAsInt();
        }
        if ("host".equals(upgradeFactoryKey)) {
            OptionalInt hostBuildNumber = this.getBuildNumberFromUpgradeHistoryTable();
            return hostBuildNumber.orElse(0);
        }
        return 0;
    }

    private OptionalInt getBuildNumberFromUpgradeHistoryTable() {
        return this.queryDslAccessor.withNewConnection().executeQuery(dbConnection -> {
            List upgrades = ((SQLQuery)dbConnection.newSqlQuery().select((Expression)QUpgradeHistory.UPGRADE_HISTORY).from((Expression)QUpgradeHistory.UPGRADE_HISTORY)).fetch();
            OptionalInt versionAbove64006 = upgrades.stream().filter(upgrade -> upgrade.getStatus() != null && upgrade.getStatus().equals("complete")).filter(upgrade -> upgrade.getTargetbuild() != null && upgrade.getTargetbuild().matches("^\\d+$")).mapToInt(upgrade -> Integer.parseInt(upgrade.getTargetbuild())).max();
            if (versionAbove64006.isPresent()) {
                return versionAbove64006;
            }
            OptionalInt versionAbove519 = upgrades.stream().filter(upgrade -> upgrade.getStatus() == null || upgrade.getStatus().equals("")).filter(upgrade -> upgrade.getTargetbuild() != null && upgrade.getTargetbuild().matches("^\\d+$")).mapToInt(upgrade -> Integer.parseInt(upgrade.getTargetbuild())).max();
            if (versionAbove519.isPresent()) {
                return versionAbove519;
            }
            OptionalInt versionAbove466 = upgrades.stream().filter(upgrade -> upgrade.getTargetbuild() == null || upgrade.getTargetbuild().equals("")).filter(upgrade -> upgrade.getUpgradeclass() != null && upgrade.getUpgradeclass().matches("^com.atlassian.jira.upgrade.tasks.UpgradeTask_Build\\d+$")).mapToInt(upgrade -> {
                String upgradeClass = upgrade.getUpgradeclass();
                String buildNumberString = upgradeClass.replace("com.atlassian.jira.upgrade.tasks.UpgradeTask_Build", "");
                return Integer.parseInt(buildNumberString);
            }).max();
            return versionAbove466;
        });
    }

    public Collection<UpgradeTaskHistory> getAllUpgradeTaskHistory(String upgradeFactoryKey) {
        List upgradeTaskHistoryDTOs = this.queryDslAccessor.withNewConnection().executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY).from((Expression)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY)).where((Predicate)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.upgradeTaskFactoryKey.eq((Object)upgradeFactoryKey))).fetch());
        return upgradeTaskHistoryDTOs.stream().map(this::convert).collect(Collectors.toList());
    }

    private UpgradeTaskHistory convert(UpgradeTaskHistoryDTO dto) {
        return new UpgradeTaskHistory(Integer.valueOf(dto.getId().intValue()), dto.getUpgradeTaskFactoryKey(), dto.getBuildNumber().intValue(), UpgradeTaskHistory.Status.valueOf((String)dto.getStatus()), UpgradeTaskHistory.UpgradeType.valueOf((String)dto.getUpgradeType()));
    }
}

