/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.upgrade.AbstractDowngradeTask;
import com.atlassian.jira.upgrade.DowngradeException;
import com.atlassian.jira.upgrade.ReindexRequirement;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DowngradeTask_Build9150000
extends AbstractDowngradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(DowngradeTask_Build9150000.class);

    @Override
    public int getBuildNumber() {
        return 9150000;
    }

    @Override
    @Nonnull
    public String getShortDescription() {
        return "Removes an unique constraint from propertyentry table.";
    }

    @Override
    public void downgrade() throws DowngradeException {
        String helperName;
        DelegatorInterface delegatorInterface = this.getOfBizDelegator().getDelegatorInterface();
        String entityName = QOSPropertyEntry.O_S_PROPERTY_ENTRY.getEntityName();
        try {
            helperName = delegatorInterface.getEntityHelper(entityName).getHelperName();
        }
        catch (GenericEntityException e) {
            String message = "Unable to get entityHelper for " + entityName;
            LOG.error(message, (Throwable)e);
            throw new DowngradeException(message);
        }
        DatabaseUtil dbUtil = new DatabaseUtil(helperName);
        ModelEntity modelEntity = delegatorInterface.getModelEntity(entityName);
        ModelIndex index = modelEntity.getIndex("osproperty_entId_name_propKey");
        dbUtil.deleteDeclaredIndex(modelEntity, index);
        dbUtil.createDeclaredIndex(modelEntity, index);
    }

    @Override
    @Nonnull
    public ReindexRequirement reindexRequired() {
        return ReindexRequirement.NONE;
    }
}

