/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.GenericConfigurationDTO;
import com.atlassian.jira.model.querydsl.JiraRelationalPathBase;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.RelationalPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build72001
extends AbstractDelayableUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build72001.class);
    private static final String DEFAULT_DATE = "<sql-timestamp>0001-01-01 00:00:00.0</sql-timestamp>";
    private final QueryDslAccessor db;

    public UpgradeTask_Build72001(QueryDslAccessor dbConnectionManager) {
        this.db = dbConnectionManager;
    }

    @Override
    public int getBuildNumber() {
        return 72001;
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }

    @Override
    public String getShortDescription() {
        return "Fix default date and time values for custom fields";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        QGenericConfiguration GENERIC_CONFIGURATION = new QGenericConfiguration("GENERIC_CONFIGURATION");
        long affectedRows = this.isMSSQL() ? this.db.executeQuery(dbConnection -> dbConnection.update((RelationalPath<?>)GENERIC_CONFIGURATION).set((Path)GENERIC_CONFIGURATION.xmlvalue, (Object)DEFAULT_DATE).where(new Predicate[]{GENERIC_CONFIGURATION.xmlvalue.like("<sql-timestamp>0001-%"), GENERIC_CONFIGURATION.xmlvalue.notLike(DEFAULT_DATE)}).execute()).longValue() : this.db.executeQuery(dbConnection -> dbConnection.update((RelationalPath<?>)GENERIC_CONFIGURATION).set((Path)GENERIC_CONFIGURATION.xmlvalue, (Object)DEFAULT_DATE).where(new Predicate[]{GENERIC_CONFIGURATION.xmlvalue.like("<sql-timestamp>0001-%"), GENERIC_CONFIGURATION.xmlvalue.ne((Object)DEFAULT_DATE)}).execute()).longValue();
        if (affectedRows > 0L) {
            log.info("Fixed {} default custom fields dates.", (Object)affectedRows);
        }
    }

    private static class QGenericConfiguration
    extends JiraRelationalPathBase<GenericConfigurationDTO> {
        public final NumberPath<Long> id = this.createNumber("id", Long.class);
        public final StringPath datatype = this.createString("datatype");
        public final StringPath datakey = this.createString("datakey");
        public final StringPath xmlvalue = this.createString("xmlvalue");

        public QGenericConfiguration(String alias) {
            super(GenericConfigurationDTO.class, alias, "genericconfiguration");
        }

        @Override
        public String getEntityName() {
            return "GenericConfiguration";
        }
    }
}

