/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarFileStoreProvider;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build72002
extends AbstractDelayableUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build72002.class);
    private static final String TAG = UpgradeTask_Build72002.class.getSimpleName();
    private static final String PNG_EXTENSION = ".png";
    private final AvatarFileStoreProvider avatarFileStoreProvider;
    private final AvatarManager avatarManager;

    public UpgradeTask_Build72002(AvatarFileStoreProvider avatarFileStoreProvider, AvatarManager avatarManager) {
        this.avatarFileStoreProvider = avatarFileStoreProvider;
        this.avatarManager = avatarManager;
    }

    @Override
    public int getBuildNumber() {
        return 72002;
    }

    @Override
    public String getShortDescription() {
        return "Removing old issue type icon files (PNGs)";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        FileStore.Path avatarBasePath = this.avatarFileStoreProvider.getBasePath();
        for (Avatar avatar : this.avatarManager.getAllSystemAvatars(IconType.ISSUE_TYPE_ICON_TYPE)) {
            String filename = FilenameUtils.removeExtension((String)avatar.getFileName());
            for (Avatar.Size size : Avatar.Size.values()) {
                String filenamePng = size.getParam() + "_" + filename + PNG_EXTENSION;
                String filenamePng2 = size.getParam() + "_images_icons_issuetypes_" + filename + PNG_EXTENSION;
                try {
                    FileStore.Path file = avatarBasePath.path(new String[]{filenamePng});
                    file.tryDeleteFile();
                    FileStore.Path file2 = avatarBasePath.path(new String[]{filenamePng2});
                    file2.tryDeleteFile();
                }
                catch (Exception e) {
                    log.error(TAG, (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }
}

