/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.PropertiesManager;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.opensymphony.module.propertyset.PropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build73002
extends AbstractDelayableUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build73002.class);
    private final PropertiesManager propertiesManager;

    public UpgradeTask_Build73002(PropertiesManager propertiesManager) {
        this.propertiesManager = propertiesManager;
    }

    @Override
    public int getBuildNumber() {
        return 73002;
    }

    @Override
    public String getShortDescription() {
        return "Reset admin settings for Rich Text Editor.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        PropertySet propertySet = this.propertiesManager.getPropertySet();
        if (propertySet.exists("jira.rte.enabled")) {
            if (!propertySet.getBoolean("jira.rte.enabled")) {
                propertySet.remove("jira.rte.enabled");
                log.info("{} application property was reset. Rich Text Editor is enabled by default.", (Object)"jira.rte.enabled");
            } else {
                log.debug("{} application property was not reset. Rich Text Editor is already enabled.", (Object)"jira.rte.enabled");
            }
        } else {
            log.debug("{} application property was not found. Rich Text Editor is enabled by default.", (Object)"jira.rte.enabled");
        }
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }
}

