/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QUpgradeHistory;
import com.atlassian.jira.model.querydsl.QUpgradeTaskHistory;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.spi.UpgradeTask;
import com.google.common.annotations.VisibleForTesting;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build73010
implements UpgradeTask {
    @VisibleForTesting
    static final Integer BUILD_NUMBER = 73010;
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build73010.class);
    private final QueryDslAccessor queryDslAccessor;

    public UpgradeTask_Build73010(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    public int getBuildNumber() {
        return BUILD_NUMBER;
    }

    public String getShortDescription() {
        return "Moves any of the old upgrade task build numbers from the new table back to the old table as when they are executed in the new framework they are placed into the new UpgradeTaskHistory table which is not desired.";
    }

    public void runUpgrade(UpgradeContext upgradeContext) {
        log.info("Starting: migration upgrade task {}", (Object)this.getBuildNumber());
        this.queryDslAccessor.execute(connection -> {
            List<Integer> buildNumbersInNewTable = this.getOldUpgradesCompletedInTheNewTable(connection);
            this.removeUpgradesFromOldTable(connection, buildNumbersInNewTable);
            this.removeUpgradesFromNewTable(connection, buildNumbersInNewTable);
            this.addUpgradesToOldTable(connection, buildNumbersInNewTable);
        });
        log.info("Finished: migration upgrade task {}", (Object)this.getBuildNumber());
    }

    @VisibleForTesting
    void addUpgradesToOldTable(DbConnection connection, List<Integer> buildNumbersInNewTable) {
        buildNumbersInNewTable.forEach(buildNumber -> connection.insert(QUpgradeHistory.UPGRADE_HISTORY).set((Path)QUpgradeHistory.UPGRADE_HISTORY.upgradeclass, this.getOldUpgradeTaskClassName((Integer)buildNumber)).set((Path)QUpgradeHistory.UPGRADE_HISTORY.targetbuild, String.valueOf(buildNumber)).set((Path)QUpgradeHistory.UPGRADE_HISTORY.status, "complete").set((Path)QUpgradeHistory.UPGRADE_HISTORY.downgradetaskrequired, "N").executeWithId());
    }

    private void removeUpgradesFromNewTable(DbConnection connection, List<Integer> buildNumbersInNewTable) {
        connection.delete((RelationalPath<?>)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY).where((Predicate)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.buildNumber.in(buildNumbersInNewTable).and((Predicate)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.upgradeTaskFactoryKey.eq((Object)"host"))).execute();
    }

    private void removeUpgradesFromOldTable(DbConnection connection, List<Integer> buildNumbersInNewTable) {
        List upgradeClassNames = buildNumbersInNewTable.stream().map(this::getOldUpgradeTaskClassName).collect(Collectors.toList());
        connection.delete((RelationalPath<?>)QUpgradeHistory.UPGRADE_HISTORY).where((Predicate)QUpgradeHistory.UPGRADE_HISTORY.upgradeclass.in(upgradeClassNames)).execute();
    }

    private List<Integer> getOldUpgradesCompletedInTheNewTable(DbConnection connection) {
        return ((SQLQuery)((SQLQuery)connection.newSqlQuery().select(QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.buildNumber).from((Expression)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY)).where((Predicate)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.buildNumber.lt((Number)this.getBuildNumber()).and((Predicate)QUpgradeTaskHistory.UPGRADE_TASK_HISTORY.upgradeTaskFactoryKey.eq((Object)"host")))).fetch();
    }

    private String getOldUpgradeTaskClassName(Integer buildNumber) {
        return "com.atlassian.jira.upgrade.tasks.UpgradeTask_Build" + buildNumber;
    }
}

