/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QClusteredJob;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build77001
extends AbstractDelayableUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build77001.class);
    private final QueryDslAccessor queryDslAccessor;
    private final DelegatorInterface delegatorInterface;

    public UpgradeTask_Build77001(QueryDslAccessor queryDslAccessor, DelegatorInterface delegatorInterface) {
        this.queryDslAccessor = queryDslAccessor;
        this.delegatorInterface = delegatorInterface;
    }

    @Override
    public int getBuildNumber() {
        return 77001;
    }

    @Override
    public String getShortDescription() {
        return "Adds a unique constraint to job id column of the clustered jobs table after ensuring that all job ids are unique";
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        long deletedJobs = this.queryDslAccessor.withNewConnection().executeQuery(dbConnection -> this.clusteredJobsDeduplicationQuery(dbConnection).execute());
        if (deletedJobs > 0L) {
            log.info("Deleted {} jobs from the clustered jobs table that had duplicate job ids.", (Object)deletedJobs);
        }
        ModelEntity clusteredJobEntity = this.delegatorInterface.getModelEntity("ClusteredJob");
        ModelIndex clusteredJobIdIndex = clusteredJobEntity.getIndex("clusteredjob_jobid_idx");
        String helperName = this.delegatorInterface.getEntityHelper("ClusteredJob").getHelperName();
        DatabaseUtil dbutil = new DatabaseUtil(helperName);
        dbutil.deleteDeclaredIndex(clusteredJobEntity, clusteredJobIdIndex);
        dbutil.createDeclaredIndex(clusteredJobEntity, clusteredJobIdIndex);
    }

    private SQLDeleteClause clusteredJobsDeduplicationQuery(DbConnection connection) {
        QClusteredJob jobs = new QClusteredJob("jobs");
        return connection.delete((RelationalPath<?>)QClusteredJob.CLUSTERED_JOB).where((Predicate)QClusteredJob.CLUSTERED_JOB.id.notIn((SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression)jobs.id.max()).from(this.loadedClusteredJobs(), (Path)jobs)).groupBy((Expression)jobs.jobId)));
    }

    private SQLQuery<Tuple> loadedClusteredJobs() {
        QClusteredJob preload = new QClusteredJob("preload");
        return (SQLQuery)SQLExpressions.select((Expression[])new Expression[]{preload.id, preload.jobId}).from((Expression)preload);
    }
}

