/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.crowd.crypto.Algorithm;
import com.atlassian.crowd.crypto.DbConfigPasswordCipherEncryptor;
import com.atlassian.crowd.crypto.SaltingEncryptor;
import com.atlassian.crowd.embedded.api.Encryptor;
import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.db.config.password.CipherProvider;
import com.atlassian.db.config.password.DefaultCipherProvider;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationPropertiesImpl;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QDirectoryAttribute;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyString;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.spi.UpgradeTask;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.io.File;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build814001
implements UpgradeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeTask_Build814001.class);
    public static final String CROWD_ENCRYPTION_ENCRYPTOR_DEFAULT = "crowd.encryption.encryptor.default";
    public static final String CROWD_ENCRYPTION_ENCRYPTOR_KEY_PATH = "crowd.encryption.encryptor.AES.keyPath";
    private static final String ENCRYPTION_KEY = "AES";
    private static final String ENCRYPTION_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String KEYS_DIRECTORY = "keys";
    private static final String DEFAULT_ENCRYPTION_TYPE = Algorithm.AES.getKey();
    private static final String ENCRYPTION_TYPE_PREFIX = "{AES_CBC_PKCS5Padding}";
    private static final String JIRA_MAIN_PROPERTIES_TYPE = "jira.properties";
    public static final int BUILD_NUMBER = 814001;
    private final QueryDslAccessor queryDslAccessor;
    private final ClusterLockService clusterLockService;
    private final String keysDirectory;
    @VisibleForTesting
    UpgradeTaskEncryptionSettings encryptionSettings;

    public UpgradeTask_Build814001(QueryDslAccessor queryDslAccessor, ClusterLockService clusterLockService, FileStores fileStores) {
        this.queryDslAccessor = queryDslAccessor;
        this.clusterLockService = clusterLockService;
        this.keysDirectory = fileStores.getHomeFilesystemPath().path(new String[]{KEYS_DIRECTORY}).asJavaPath().toString();
        this.encryptionSettings = new UpgradeTaskEncryptionSettings(ENCRYPTION_KEY, this.keysDirectory);
    }

    public int getBuildNumber() {
        return 814001;
    }

    @Nonnull
    public String getShortDescription() {
        return "Encrypt AD/LDAP servers passwords.";
    }

    public void runUpgrade(UpgradeContext upgradeContext) {
        ClusterLock lock = this.clusterLockService.getLockForName(UpgradeTask_Build814001.class.getName());
        if (!lock.tryLock()) {
            LOGGER.warn(String.format("Unable to acquire %s lock. Failing the upgrade task.", UpgradeTask_Build814001.class.getName()));
            throw new ConcurrentModificationException(String.format("%d upgrade task has failed. Unable to acquire %s lock", 814001, lock));
        }
        try {
            if (this.isEncryptionAlreadyConfigured().booleanValue()) {
                LOGGER.info("Encryption already enabled. Skipping upgrade task");
            } else {
                this.encryptPasswordsAndSaveConfiguration();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private Boolean isEncryptionAlreadyConfigured() {
        return this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).join((EntityPath)QOSPropertyString.O_S_PROPERTY_STRING)).on((Predicate)QOSPropertyString.O_S_PROPERTY_STRING.id.eq(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)JIRA_MAIN_PROPERTIES_TYPE).and((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)CROWD_ENCRYPTION_ENCRYPTOR_DEFAULT)).and((Predicate)QOSPropertyString.O_S_PROPERTY_STRING.value.isNotNull()))).fetchCount() > 0L);
    }

    private void encryptPasswordsAndSaveConfiguration() {
        LOGGER.info("Enabling encryption");
        this.createKeysDirectory(this.keysDirectory);
        Encryptor encryptor = this.getAndPrepareEncryptor(this.encryptionSettings);
        UnaryOperator passwordTransformer = password -> ENCRYPTION_TYPE_PREFIX + encryptor.encrypt(password);
        this.queryDslAccessor.execute(connection -> {
            this.encryptPasswords(passwordTransformer, connection);
            this.createApplicationProperty(connection, CROWD_ENCRYPTION_ENCRYPTOR_DEFAULT, DEFAULT_ENCRYPTION_TYPE);
            this.createApplicationProperty(connection, CROWD_ENCRYPTION_ENCRYPTOR_KEY_PATH, this.encryptionSettings.getEncryptionKeyPath(ENCRYPTION_KEY).get());
        });
        ComponentAccessor.getComponentSafely(ApplicationPropertiesImpl.class).ifPresent(ApplicationPropertiesImpl::refresh);
    }

    private void createKeysDirectory(String keysDirectory) {
        File file = new File(keysDirectory);
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Migration failed. Could not create directory for encryption keys.");
        }
    }

    @Nonnull
    private Encryptor getAndPrepareEncryptor(EncryptionSettings encryptionSettings) {
        DefaultCipherProvider cipherProvider = new DefaultCipherProvider();
        SaltingEncryptor encryptor = new SaltingEncryptor((Encryptor)new DbConfigPasswordCipherEncryptor(ENCRYPTION_ALGORITHM, ENCRYPTION_KEY, encryptionSettings, (CipherProvider)cipherProvider));
        encryptor.changeEncryptionKey();
        return encryptor;
    }

    private void encryptPasswords(UnaryOperator<String> encryptor, DbConnection connection) {
        List passwordAttributes = ((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)QDirectoryAttribute.DIRECTORY_ATTRIBUTE).from((Expression)QDirectoryAttribute.DIRECTORY_ATTRIBUTE)).where((Predicate)QDirectoryAttribute.DIRECTORY_ATTRIBUTE.name.in((Collection)DirectoryImpl.PASSWORD_ATTRIBUTES))).fetch();
        passwordAttributes.forEach(attribute -> {
            if (attribute.getValue() != null && this.isNotAlreadyEncrypted(attribute.getValue())) {
                connection.update((RelationalPath<?>)QDirectoryAttribute.DIRECTORY_ATTRIBUTE).set((Path)QDirectoryAttribute.DIRECTORY_ATTRIBUTE.value, encryptor.apply(attribute.getValue())).where((Predicate)QDirectoryAttribute.DIRECTORY_ATTRIBUTE.directoryId.eq((Object)attribute.getDirectoryId()).and((Predicate)QDirectoryAttribute.DIRECTORY_ATTRIBUTE.name.eq((Object)attribute.getName()))).execute();
            }
        });
    }

    private boolean isNotAlreadyEncrypted(String value) {
        return !value.startsWith(ENCRYPTION_TYPE_PREFIX);
    }

    private void createApplicationProperty(DbConnection connection, String entryKey, String entryValue) {
        long countOfUpdatedRows;
        Long algorithmEntryId = (Long)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).join((EntityPath)QOSPropertyString.O_S_PROPERTY_STRING)).on((Predicate)QOSPropertyString.O_S_PROPERTY_STRING.id.eq(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)JIRA_MAIN_PROPERTIES_TYPE).and((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)entryKey)))).fetchFirst();
        if (algorithmEntryId == null) {
            algorithmEntryId = connection.insert(QOSPropertyEntry.O_S_PROPERTY_ENTRY).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName, JIRA_MAIN_PROPERTIES_TYPE).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId, (Object)1L).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey, entryKey).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.type, (Object)5).executeWithId();
        }
        if ((countOfUpdatedRows = connection.update((RelationalPath<?>)QOSPropertyString.O_S_PROPERTY_STRING).set((Path)QOSPropertyString.O_S_PROPERTY_STRING.value, (Object)entryValue).where((Predicate)QOSPropertyString.O_S_PROPERTY_STRING.id.eq((Object)algorithmEntryId)).execute()) == 0L) {
            connection.insert(QOSPropertyString.O_S_PROPERTY_STRING).set((Path)QOSPropertyString.O_S_PROPERTY_STRING.value, entryValue).set((Path)QOSPropertyString.O_S_PROPERTY_STRING.id, algorithmEntryId).execute();
        }
    }

    static class UpgradeTaskEncryptionSettings
    implements EncryptionSettings {
        Map<String, String> encryptionKeys = new HashMap<String, String>();
        final String encryptionKey;
        final String keysDirectory;

        UpgradeTaskEncryptionSettings(String encryptionKey, String keysDirectory) {
            this.encryptionKey = encryptionKey;
            this.keysDirectory = keysDirectory;
        }

        public Optional<String> getDefaultEncryptor() {
            return Optional.ofNullable(this.encryptionKey);
        }

        public void setDefaultEncryptor(String name) {
        }

        public void setEncryptionKeyPath(String encryptor, String keyPath) {
            this.encryptionKeys.put(encryptor, keyPath);
        }

        public Optional<String> getEncryptionKeyPath(String encryptor) {
            return Optional.ofNullable(this.encryptionKeys.get(encryptor));
        }

        public String getKeyFilesDirectoryPath() {
            return this.keysDirectory;
        }
    }
}

