/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.CachingComponent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.tasks.role.License;
import com.atlassian.jira.upgrade.tasks.role.LicenseDao;
import com.atlassian.jira.upgrade.tasks.role.Licenses;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class LicenseDaoImpl
extends LicenseDao {
    private static final String ENTITY_NAME = "ProductLicense";
    private static final String COL_LICENSE = "license";
    private final ApplicationProperties properties;
    private final CachingComponent licenseCache;
    private final OfBizDelegator db;

    public LicenseDaoImpl(ApplicationProperties properties, OfBizDelegator db, JiraLicenseManager licenseCache) {
        Assertions.notNull((String)"licenseCache", (Object)licenseCache);
        this.properties = (ApplicationProperties)Assertions.notNull((String)"properties", (Object)properties);
        this.db = (OfBizDelegator)Assertions.notNull((String)"db", (Object)db);
        if (!(licenseCache instanceof CachingComponent)) {
            throw new IllegalArgumentException("'licenseCache' is not a cache.");
        }
        this.licenseCache = (CachingComponent)licenseCache;
    }

    @Override
    Option<License> get6xLicense() {
        try {
            return Option.option((Object)StringUtils.stripToNull((String)this.properties.getText("License20"))).map(License::new);
        }
        catch (MigrationFailedException e) {
            throw new MigrationFailedException("JIRA 6.x license stored in JIRA is not valid: " + e.getMessage(), e);
        }
    }

    @Override
    Licenses getLicenses() {
        try {
            Iterable licenses = (Iterable)this.db.findAll(ENTITY_NAME).stream().map(gv -> gv.getString(COL_LICENSE)).map(License::new).collect(CollectorsUtil.toImmutableSet());
            return new Licenses(licenses);
        }
        catch (MigrationFailedException e) {
            throw new MigrationFailedException("Licenses stored in JIRA are not valid: " + e.getMessage(), e);
        }
    }

    @Override
    void setLicenses(Licenses licenses) {
        Set<License> currentLicenses;
        Set<License> newLicenses = ((Licenses)Assertions.notNull((String)"licenses", (Object)licenses)).get();
        if (!newLicenses.containsAll(currentLicenses = this.getLicenses().get())) {
            throw new MigrationFailedException("Unable to remove licenses from the store.");
        }
        for (License licenseToAdd : Sets.difference(newLicenses, currentLicenses)) {
            this.db.createValue(ENTITY_NAME, (Map)ImmutableMap.of((Object)COL_LICENSE, (Object)licenseToAdd.licenseString()));
        }
        this.licenseCache.clearCache();
    }

    @Override
    void remove6xLicense() {
        this.properties.setText("License20", null);
    }
}

