/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.jira.bc.dataimport.DatabaseImportCompletedEvent;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.propertyset.CachingOfBizPropertySet;
import com.atlassian.jira.propertyset.SingleEntityCachingOfBizPropertyEntryStore;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.module.propertyset.PropertySet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultUserPropertyManager
implements UserPropertyManager,
Startable {
    public static final String APPLICATION_USER_ENTITY_NAME = "ApplicationUser";
    private final UserKeyStore userKeyStore;
    private final SingleEntityCachingOfBizPropertyEntryStore applicationUserOfBizPropertyEntryStore;
    private final EventListenerRegistrar eventListenerRegistrar;

    public DefaultUserPropertyManager(UserKeyStore userKeyStore, QueryDslAccessor queryDslAccessor, CacheManager cacheManager, EventListenerRegistrar eventListenerRegistrar) {
        this.userKeyStore = userKeyStore;
        this.applicationUserOfBizPropertyEntryStore = new SingleEntityCachingOfBizPropertyEntryStore(UserPropertyManager.class.getSimpleName() + "." + APPLICATION_USER_ENTITY_NAME + ".cache", queryDslAccessor, cacheManager, false);
        this.eventListenerRegistrar = eventListenerRegistrar;
    }

    public void start() throws Exception {
        this.eventListenerRegistrar.register((Object)this);
    }

    @Nonnull
    public PropertySet getPropertySet(@Nonnull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        return this.getPropertySetForUserKey(user.getKey());
    }

    @Nonnull
    public PropertySet getPropertySet(long userId) {
        return this.userKeyStore.getUserForId(userId).map(ApplicationUserEntity::getId).map(this::getPropertySetForUserId).orElseThrow(() -> new IllegalStateException("There is no ID mapped for the user ID '" + userId + '\''));
    }

    @Nonnull
    public PropertySet getPropertySetForUserKey(@Nonnull String userKey) {
        Long id = this.userKeyStore.getIdForUserKey((String)Assertions.notNull((String)"userKey", (Object)userKey));
        if (id == null) {
            throw new IllegalStateException("There is no ID mapped for the user key '" + userKey + '\'');
        }
        return this.getPropertySetForUserId(id);
    }

    @Nonnull
    private PropertySet getPropertySetForUserId(long userId) {
        return new CachingOfBizPropertySet(this.applicationUserOfBizPropertyEntryStore, APPLICATION_USER_ENTITY_NAME, userId);
    }

    @EventListener
    public void onClearCache(@Nullable ClearCacheEvent event) {
        this.applicationUserOfBizPropertyEntryStore.refreshAll();
    }

    @EventListener
    public void onDatabaseImportCompleted(DatabaseImportCompletedEvent event) {
        this.applicationUserOfBizPropertyEntryStore.refreshAll();
    }
}

