/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.a11y;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.user.a11y.A11yPersonalSetting;
import com.atlassian.jira.user.a11y.A11yPersonalSettingImage;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dom4j.Element;

public class A11yPersonalSettingModuleDescriptor
extends AbstractModuleDescriptor<A11yPersonalSetting> {
    @VisibleForTesting
    static final String A11Y_SETTING_PREFIX = "a11y-setting-";
    private A11yPersonalSetting personalSetting;

    public A11yPersonalSettingModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) {
        super.init(plugin, element);
        this.personalSetting = this.parseA11yElement(element);
    }

    @Nullable
    public A11yPersonalSetting getModule() {
        return this.personalSetting;
    }

    private A11yPersonalSetting parseA11yElement(Element root) {
        String key = A11Y_SETTING_PREFIX + root.attributeValue("key");
        if (!A11yPersonalSettingModuleDescriptor.isAllowedA11yElementKey(key)) {
            throw new PluginParseException("Invalid key given for a11y-personal-setting element. Should contain [a-z0-9_-] only.");
        }
        String labelKey = root.element("label").attributeValue("key");
        String descriptionKey = root.element("description").attributeValue("key");
        A11yPersonalSettingImage image = this.getImage(root.elements("image"));
        return new A11yPersonalSetting(key, labelKey, descriptionKey, image);
    }

    @Nullable
    private A11yPersonalSettingImage getImage(List<Element> elements) {
        if (elements.size() > 1) {
            throw new PluginParseException("At most one preview image is allowed.");
        }
        return elements.isEmpty() ? null : this.getImage(elements.get(0));
    }

    private A11yPersonalSettingImage getImage(Element imageElement) {
        String moduleCompleteKey = imageElement.attributeValue("module-complete-key");
        String resourceName = imageElement.attributeValue("resource-name");
        String alternateTextKey = imageElement.attributeValue("alternate-text-key");
        try {
            return new A11yPersonalSettingImage(moduleCompleteKey, resourceName, alternateTextKey);
        }
        catch (Exception e) {
            throw new PluginParseException((Throwable)e);
        }
    }

    private static boolean isAllowedA11yElementKey(String key) {
        return key != null && key.matches("^[a-z0-9_\\-]+$");
    }
}

