/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class BusinessLogicValidationResult
implements Serializable {
    private final ImmutableMap<String, ErrorCollection> handlerToErrorsMap;

    public BusinessLogicValidationResult(Map<String, ? extends ErrorCollection> handlerToErrorsMap) {
        this.handlerToErrorsMap = (ImmutableMap)handlerToErrorsMap.entrySet().stream().filter(entry -> ((ErrorCollection)entry.getValue()).hasAnyErrors()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static BusinessLogicValidationResult empty() {
        return new BusinessLogicValidationResult((Map<String, ? extends ErrorCollection>)ImmutableMap.of());
    }

    public Map<String, ErrorCollection> getHandlerToErrorsMap() {
        return this.handlerToErrorsMap;
    }

    public boolean isValid() {
        return this.handlerToErrorsMap.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ImmutableMap.Builder<String, ErrorCollection> mapBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public Builder addHandlerToErrorsMap(Map<String, ErrorCollection> handlerToErrorsMap) {
            this.mapBuilder.putAll(handlerToErrorsMap);
            return this;
        }

        public Builder addPartialResult(BusinessLogicValidationResult partialResult) {
            this.mapBuilder.putAll(partialResult.getHandlerToErrorsMap());
            return this;
        }

        public BusinessLogicValidationResult build() {
            return new BusinessLogicValidationResult((Map<String, ? extends ErrorCollection>)this.mapBuilder.build());
        }

        public Builder merge(Builder otherBuilder) {
            this.mapBuilder.putAll((Map)otherBuilder.mapBuilder.build());
            return this;
        }
    }
}

