/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.SimpleWarningCollection;
import com.atlassian.jira.util.WarningCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DelegatingChangeHandler
implements UserKeyChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(DelegatingChangeHandler.class);
    private static final String DESCRIPTION_KEY = "foreign.keys.change.handler.common.name";
    protected final JiraAuthenticationContext jiraAuthenticationContext;

    public DelegatingChangeHandler(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return ImmutableList.of((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).descriptionKey(DESCRIPTION_KEY).build());
    }

    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        SimpleWarningCollection warningCollection = new SimpleWarningCollection();
        this.getHandlers().stream().map(handler -> {
            try {
                return handler.update((Object)userPropertyChangeParameter);
            }
            catch (Exception exception) {
                log.error("Exception during foreign keys update", (Throwable)exception);
                SimpleErrorCollection errors = new SimpleErrorCollection();
                String errorMessage = this.jiraAuthenticationContext.getI18nHelper().getText("foreign.keys.change.handler.update.error", handler.toString(), exception.getMessage());
                errors.addErrorMessage(errorMessage);
                return new ServiceResultImpl((ErrorCollection)errors);
            }
        }).forEach(arg_0 -> DelegatingChangeHandler.lambda$update$1((ErrorCollection)errorCollection, (WarningCollection)warningCollection, arg_0));
        return new ServiceResultImpl((ErrorCollection)errorCollection, (WarningCollection)warningCollection);
    }

    public int getNumberOfTasks(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return this.getHandlers().stream().mapToInt(handler -> handler.getNumberOfTasks((Object)userPropertyChangeParameter)).sum();
    }

    @Nonnull
    public abstract Collection<UserKeyChangeHandler> getHandlers();

    private static /* synthetic */ void lambda$update$1(ErrorCollection errorCollection, WarningCollection warningCollection, ServiceResult result) {
        errorCollection.addErrorCollection(result.getErrorCollection());
        warningCollection.addWarnings(result.getWarningCollection());
    }
}

