/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.handlers.key.info.ForeignKeyInfo;
import com.atlassian.jira.util.I18nHelper;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericUserKeyChangeHandler
implements UserKeyChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(GenericUserKeyChangeHandler.class);
    private static final String NAME_PREFIX_KEY = "anonymization.fk.prefix";
    protected final QueryDslAccessor queryDslAccessor;
    protected final ForeignKeyInfo foreignKeyInfo;
    protected final int numberOfTasks;
    protected final EventPublisher eventPublisher;

    public GenericUserKeyChangeHandler(QueryDslAccessor queryDslAccessor, EventPublisher eventPublisher, ForeignKeyInfo foreignKeyInfo, int numberOfTasks) {
        this.queryDslAccessor = queryDslAccessor;
        this.eventPublisher = eventPublisher;
        this.foreignKeyInfo = foreignKeyInfo;
        this.numberOfTasks = numberOfTasks;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return this.update(userPropertyChangeParameter, this.getNumberOfTasks(userPropertyChangeParameter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter, int numberOfTasks) {
        long updatedCount;
        String original = userPropertyChangeParameter.getOriginal();
        String target = userPropertyChangeParameter.getTarget();
        Context context = userPropertyChangeParameter.getContext();
        I18nHelper i18nHelper = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
        int size = this.foreignKeyInfo.getColumns().size();
        context.setName(i18nHelper.getText(NAME_PREFIX_KEY, this.foreignKeyInfo.getDescription()));
        try {
            updatedCount = this.queryDslAccessor.executeQuery(connection -> {
                long count = connection.update((RelationalPath<?>)this.foreignKeyInfo.getTable()).set(this.foreignKeyInfo.getColumns(), Collections.nCopies(size, target)).where(this.foreignKeyInfo.getWhere(original)).execute();
                log.info("Updated {} {} ({}) entities for {}", new Object[]{count, this.foreignKeyInfo.getName(), this.foreignKeyInfo.columnsToString(), original});
                return count;
            });
        }
        finally {
            ContextUtil.updateProgress(context, numberOfTasks);
        }
        if (updatedCount > 0L) {
            this.foreignKeyInfo.getForeignKeyChangedEvent().ifPresent(event -> {
                log.debug("Publishing foreign key changed event for {}", (Object)this.foreignKeyInfo.getClass().getSimpleName());
                this.eventPublisher.publish(event);
                log.debug("Published foreign key changed event for {}", (Object)this.foreignKeyInfo.getClass().getSimpleName());
            });
        }
        return new ServiceResultImpl();
    }

    protected List<Long> getIdsOfAffectedEntities(String original) {
        return this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)connection.newSqlQuery().select(this.foreignKeyInfo.getSelect()).from((Expression)this.foreignKeyInfo.getTable())).where(this.foreignKeyInfo.getWhere(original))).fetch());
    }

    public String toString() {
        return this.foreignKeyInfo.columnsToString();
    }

    public int getNumberOfTasks(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return this.numberOfTasks;
    }
}

