/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.DatabaseVendor;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QChangeItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.handlers.key.info.IssueHistoryInfo;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueHistoryUserKeyChangeHandler
implements UserKeyChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(IssueHistoryUserKeyChangeHandler.class);
    private static final String NAME_PREFIX_KEY = "anonymization.fk.prefix";
    protected static final String ENTITY_NAME = "issueHistory.userKey";
    protected final JiraAuthenticationContext jiraAuthenticationContext;
    protected final QueryDslAccessor queryDslAccessor;
    private final int stepNumber;
    private final List<IssueHistoryInfo> infos;
    private final DatabaseAccessor databaseAccessor;

    public IssueHistoryUserKeyChangeHandler(JiraAuthenticationContext jiraAuthenticationContext, QueryDslAccessor queryDslAccessor, DatabaseAccessor databaseAccessor, int stepNumber, List<IssueHistoryInfo> infos) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.queryDslAccessor = queryDslAccessor;
        this.stepNumber = stepNumber;
        this.infos = infos;
        this.databaseAccessor = databaseAccessor;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        String original = userPropertyChangeParameter.getOriginal();
        String target = userPropertyChangeParameter.getTarget();
        String taskName = this.jiraAuthenticationContext.getI18nHelper().getText(NAME_PREFIX_KEY, ENTITY_NAME);
        userPropertyChangeParameter.getContext().setName(taskName);
        try {
            long updated = this.getInfos().stream().mapToLong(info -> this.updateCustomField((IssueHistoryInfo)info, original, target)).sum();
            log.info("Updated {} {} entities for {}", new Object[]{updated, QChangeItem.CHANGE_ITEM.getTableName(), original});
        }
        finally {
            ContextUtil.updateProgress(userPropertyChangeParameter.getContext(), this.stepNumber);
        }
        return new ServiceResultImpl();
    }

    public int getNumberOfTasks(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return this.stepNumber;
    }

    protected List<IssueHistoryInfo> getInfos() {
        return this.infos;
    }

    protected List<Long> getAffectedEntitiesIds(String original, IssueHistoryInfo foreignKeyInfo) {
        return this.queryDslAccessor.executeQuery(connection -> this.getBaseQuery(original, foreignKeyInfo, connection).fetch());
    }

    protected SQLQuery<Long> getBaseQuery(String original, IssueHistoryInfo foreignKeyInfo, DbConnection connection) {
        return (SQLQuery)((SQLQuery)connection.newSqlQuery().select(foreignKeyInfo.getSelect()).from((Expression)foreignKeyInfo.getTable())).where(foreignKeyInfo.getWhere(original, this.databaseAccessor.getDatabaseVendor()));
    }

    protected long updateCustomField(IssueHistoryInfo info, String original, String target) {
        return this.queryDslAccessor.executeQuery(connection -> {
            long affected = connection.update((RelationalPath<?>)info.getTable()).set(info.getColumn(), (Object)target).set((Path)info.getColumnHumanReadable(), (Object)target).where((Predicate)QChangeItem.CHANGE_ITEM.id.in(this.getInQuery(original, info, connection))).execute();
            return affected;
        });
    }

    private SQLQuery<Long> getInQuery(String original, IssueHistoryInfo info, DbConnection connection) {
        SQLQuery<Long> baseQuery = this.getBaseQuery(original, info, connection);
        if (this.databaseAccessor.getDatabaseVendor() == DatabaseVendor.MY_SQL) {
            return (SQLQuery)SQLExpressions.select((Expression)Expressions.numberPath(Long.class, (String)"id")).from((Expression)baseQuery.as("innerQuery"));
        }
        return baseQuery;
    }
}

