/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.ownership;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QProject;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.UpdateProjectParameters;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.OwnershipTransferHandler;
import com.atlassian.jira.user.anonymize.OwnershipTransferParameter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectLeadOwnershipTransferHandler
implements OwnershipTransferHandler {
    private static final Logger log = LoggerFactory.getLogger(ProjectLeadOwnershipTransferHandler.class);
    private final QueryDslAccessor queryDslAccessor;
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public ProjectLeadOwnershipTransferHandler(QueryDslAccessor queryDslAccessor, ProjectManager projectManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.queryDslAccessor = queryDslAccessor;
        this.projectManager = projectManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull OwnershipTransferParameter ownershipTransferParameter) {
        List<Long> projectsLeadByUser = this.getProjectIdsLeadByUser(ownershipTransferParameter.getCurrentUserKey());
        if (projectsLeadByUser.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.of((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.TRANSFER_OWNERSHIP).descriptionKey("common.concepts.projectlead").numberOfOccurrences(Long.valueOf(projectsLeadByUser.size())).build());
    }

    @Nonnull
    public ServiceResult update(@Nonnull OwnershipTransferParameter ownershipTransferParameter) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        log.debug("Processing project lead change for {}", (Object)ownershipTransferParameter);
        List<Long> projectsLeadByUser = this.getProjectIdsLeadByUser(ownershipTransferParameter.getCurrentUserKey());
        log.debug("Found {} projects to update", (Object)projectsLeadByUser.size());
        for (Long projectId : projectsLeadByUser) {
            UpdateProjectParameters updateProjectParameters = UpdateProjectParameters.forProject((Long)projectId).leadUserKey(ownershipTransferParameter.getTransferToUserKey());
            try {
                this.projectManager.updateProject(updateProjectParameters);
            }
            catch (Exception e) {
                log.error(String.format("Exception during project lead change for project %d", projectId), (Throwable)e);
                errors.addErrorMessage(this.jiraAuthenticationContext.getI18nHelper().getText("change.handler.processing.exception", e.getMessage()));
            }
        }
        log.debug("Finished processing project lead change for {}", (Object)ownershipTransferParameter);
        return ServiceOutcomeImpl.from((ErrorCollection)errors);
    }

    public int getNumberOfTasks(@Nonnull OwnershipTransferParameter ownershipTransferParameter) {
        return this.getProjectIdsLeadByUser(ownershipTransferParameter.getCurrentUserKey()).size();
    }

    private List<Long> getProjectIdsLeadByUser(@Nonnull String userKey) {
        return this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)connection.newSqlQuery().select(QProject.PROJECT.id).from((Expression)QProject.PROJECT)).where((Predicate)QProject.PROJECT.lead.eq((Object)userKey))).fetch());
    }
}

