/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.key;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.user.anonymize.UserKeyChangedEvent;
import com.atlassian.jira.user.anonymize.AnonymizationHandlerModuleDescriptor;
import com.atlassian.jira.user.anonymize.BusinessLogicValidator;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.key.UserKeyChangeHandlerModuleDescriptor;
import com.atlassian.jira.user.anonymize.key.UserKeyChangeManager;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.plugin.PluginAccessor;
import javax.annotation.Nonnull;

public class DefaultUserKeyChangeManager
extends UserKeyChangeManager {
    private final UserKeyStore userKeyStore;

    public DefaultUserKeyChangeManager(PluginAccessor pluginAccessor, EventPublisher eventPublisher, UserKeyStore userKeyStore, BusinessLogicValidator businessLogicValidator) {
        super(pluginAccessor, eventPublisher, businessLogicValidator);
        this.userKeyStore = userKeyStore;
    }

    @Override
    public void changeProperty(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        this.userKeyStore.changeKey(userPropertyChangeParameter.getOriginal(), userPropertyChangeParameter.getTarget());
        this.eventPublisher.publish((Object)new UserKeyChangedEvent(userPropertyChangeParameter.getOriginal(), userPropertyChangeParameter.getTarget()));
    }

    @Override
    protected Class<? extends AnonymizationHandlerModuleDescriptor<UserKeyChangeHandler, UserPropertyChangeParameter>> getModuleDescriptorClass() {
        return UserKeyChangeHandlerModuleDescriptor.class;
    }
}

