/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.profile;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.profile.UserProfileFragment;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineActivityUserProfileFragment
implements UserProfileFragment {
    public static final String INLINE_ACTIVITY_STREAM_FEATURE_KEY = "com.atlassian.streams.InlineActivityStream";
    private static final String INLINE_ACTIVITY_STREAM_WEB_RESOURCE = "com.atlassian.streams:inline-activity-stream-resources";
    private static final Logger log = LoggerFactory.getLogger(InlineActivityUserProfileFragment.class);
    private final PluginAccessor pluginAccessor;
    private final I18nHelper.BeanFactory i18nFactory;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public InlineActivityUserProfileFragment(PluginAccessor pluginAccessor, I18nHelper.BeanFactory i18nFactory, SoyTemplateRenderer soyTemplateRenderer) {
        this.pluginAccessor = pluginAccessor;
        this.i18nFactory = i18nFactory;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    @Override
    public boolean showFragment(ApplicationUser profileUser, ApplicationUser currentUser) {
        return this.pluginAccessor.isPluginModuleEnabled(INLINE_ACTIVITY_STREAM_WEB_RESOURCE);
    }

    @Override
    public String getFragmentHtml(ApplicationUser profileUser, ApplicationUser currentUser) {
        ImmutableMap.Builder context = ImmutableMap.builder();
        String activityUrl = this.getRequestContextPath() + "/activity?maxResults=10&streams=user+IS+" + this.getJiraUrlEncoded(profileUser.getName());
        context.put((Object)"activityStreamUrl", (Object)activityUrl);
        try {
            return this.soyTemplateRenderer.render("jira.webresources:inline-activity-stream-soy-templates", "JIRA.Templates.InlineActivityStream.renderGadget", (Map)context.build());
        }
        catch (SoyException e) {
            log.error("Could not render soy template for inline activity stream");
            log.debug("Exception: ", (Throwable)e);
            return "";
        }
    }

    @Override
    public String getId() {
        return "inline-activity-profile-fragment";
    }

    @VisibleForTesting
    String getRequestContextPath() {
        return ExecutingHttpRequest.get().getContextPath();
    }

    @VisibleForTesting
    String getJiraUrlEncoded(String user) {
        return JiraUrlCodec.encode((String)user);
    }
}

