/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.jira.util.stats.LastValueSerializableStats;
import com.atlassian.jira.util.stats.ManagedStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import java.util.concurrent.atomic.AtomicLong;

public interface LoginStoreStats
extends ManagedStats {
    public static final String STATS_NAME = "LOGIN-STORE-STATS";

    public void settings(boolean var1, long var2);

    public void recordLoginAttemptTrue(long var1);

    public void recordLoginAttemptFalse(long var1);

    public void updateLastLoginTime(long var1);

    public void resetFailedLoginCount(long var1);

    public void getLoginInfo(long var1);

    public void delegateRecordLoginAttemptTrue(long var1);

    public void delegateRecordLoginAttemptFalse(long var1);

    public void delegateUpdateLastLoginTime(long var1);

    public void delegateResetFailedLoginCount(long var1);

    public void invalidateLastKnownLoginInfoCache();

    public void flushDataToDB(long var1);

    public void unscheduledFlushUserAttempts(long var1);

    public void flushRecordedSuccessfulLoginAttempts(long var1);

    public void flushLastLoginTimes(long var1);

    public void onClearCache();

    public void validateRunningFailed();

    public void flushRecordedSuccessfulLoginAttemptsUnsuccessful();

    public void flushLastLoginTimesUnsuccessful();

    public void getApplicationUserToLastKnownLoginInfoSize(long var1);

    public void lastKnownLoginInfoCacheCall();

    public void getLastKnownLoginInfo();

    public void usersFlushedToDB(long var1);

    public static LoginStoreStats create() {
        return new MutableLoginStoreStats();
    }

    public static class MutableLoginStoreStats
    implements LoginStoreStats {
        private final Settings settings = new Settings();
        private final MutableLongStats recordLoginAttemptSuccessfulInMillis = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 5000L});
        private final MutableLongStats recordLoginAttemptFailedInMillis = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 5000L});
        private final MutableLongStats updateLastLoginTimeInMillis = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 5000L});
        private final MutableLongStats resetFailedLoginCountInMillis = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 5000L});
        private final MutableLongStats getOrLoadLastKnownLoginInfoInMillis = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 5000L});
        private final MutableLongStats delegateRecordLoginAttemptSuccessfulInMillis = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 5000L});
        private final MutableLongStats delegateRecordLoginAttemptFailedInMillis = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 5000L});
        private final MutableLongStats delegateUpdateLastLoginTimeInMillis = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 5000L});
        private final MutableLongStats delegateResetFailedLoginCountInMillis = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 5000L});
        private final AtomicLong invalidateLastKnownLoginInfoCache = new AtomicLong();
        private final MutableLongStats flushDataToDBInMillis = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 5000L});
        private final MutableLongStats flushUserAttemptsInMillis = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 5000L});
        private final MutableLongStats flushRecordedSuccessfulLoginAttemptsMillis = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 5000L});
        private final MutableLongStats flushLastLoginTimesMillis = new MutableLongStats(new long[]{1L, 10L, 100L, 1000L, 5000L});
        private final AtomicLong unscheduledFlushUserAttemptsCount = new AtomicLong();
        private final AtomicLong onClearCacheCount = new AtomicLong();
        private final AtomicLong failedValidateRunningCount = new AtomicLong();
        private final AtomicLong flushRecordedSuccessfulLoginAttemptsUnsuccessfulCount = new AtomicLong();
        private final AtomicLong flushLastLoginTimesUnsuccessfulCount = new AtomicLong();
        private final AtomicLong applicationUserToLastKnownLoginInfoMaxSize = new AtomicLong();
        private final AtomicLong getLastKnownLoginInfoCacheCallCount = new AtomicLong();
        private final AtomicLong getLastKnownLoginInfoCount = new AtomicLong();
        private final MutableLongStats usersFlushedToDB = new MutableLongStats(new long[0]);

        public String getStatsName() {
            return LoginStoreStats.STATS_NAME;
        }

        @Override
        public void settings(boolean legacyMode, long flushIntervalInSeconds) {
            this.settings.legacyMode.store((Object)legacyMode);
            this.settings.flushIntervalInSeconds.store((Object)flushIntervalInSeconds);
        }

        @Override
        public void recordLoginAttemptTrue(long timeInMillis) {
            this.recordLoginAttemptSuccessfulInMillis.accept(timeInMillis);
        }

        @Override
        public void recordLoginAttemptFalse(long timeInMillis) {
            this.recordLoginAttemptFailedInMillis.accept(timeInMillis);
        }

        @Override
        public void updateLastLoginTime(long timeInMillis) {
            this.updateLastLoginTimeInMillis.accept(timeInMillis);
        }

        @Override
        public void resetFailedLoginCount(long timeInMillis) {
            this.resetFailedLoginCountInMillis.accept(timeInMillis);
        }

        @Override
        public void getLoginInfo(long timeInMillis) {
            this.getOrLoadLastKnownLoginInfoInMillis.accept(timeInMillis);
        }

        @Override
        public void delegateRecordLoginAttemptTrue(long timeInMillis) {
            this.delegateRecordLoginAttemptSuccessfulInMillis.accept(timeInMillis);
        }

        @Override
        public void delegateRecordLoginAttemptFalse(long timeInMillis) {
            this.delegateRecordLoginAttemptFailedInMillis.accept(timeInMillis);
        }

        @Override
        public void delegateUpdateLastLoginTime(long timeInMillis) {
            this.delegateUpdateLastLoginTimeInMillis.accept(timeInMillis);
        }

        @Override
        public void delegateResetFailedLoginCount(long timeInMillis) {
            this.delegateResetFailedLoginCountInMillis.accept(timeInMillis);
        }

        @Override
        public void invalidateLastKnownLoginInfoCache() {
            this.invalidateLastKnownLoginInfoCache.incrementAndGet();
        }

        @Override
        public void flushDataToDB(long timeInMillis) {
            this.flushDataToDBInMillis.accept(timeInMillis);
        }

        @Override
        public void unscheduledFlushUserAttempts(long timeInMillis) {
            this.flushUserAttemptsInMillis.accept(timeInMillis);
            this.unscheduledFlushUserAttemptsCount.incrementAndGet();
        }

        @Override
        public void flushRecordedSuccessfulLoginAttempts(long timeInMillis) {
            this.flushRecordedSuccessfulLoginAttemptsMillis.accept(timeInMillis);
        }

        @Override
        public void flushLastLoginTimes(long timeInMillis) {
            this.flushLastLoginTimesMillis.accept(timeInMillis);
        }

        @Override
        public void onClearCache() {
            this.onClearCacheCount.incrementAndGet();
        }

        @Override
        public void validateRunningFailed() {
            this.failedValidateRunningCount.incrementAndGet();
        }

        @Override
        public void flushRecordedSuccessfulLoginAttemptsUnsuccessful() {
            this.flushRecordedSuccessfulLoginAttemptsUnsuccessfulCount.incrementAndGet();
        }

        @Override
        public void flushLastLoginTimesUnsuccessful() {
            this.flushLastLoginTimesUnsuccessfulCount.incrementAndGet();
        }

        @Override
        public void getApplicationUserToLastKnownLoginInfoSize(long size) {
            this.applicationUserToLastKnownLoginInfoMaxSize.updateAndGet(c -> Math.max(c, size));
        }

        @Override
        public void lastKnownLoginInfoCacheCall() {
            this.getLastKnownLoginInfoCacheCallCount.incrementAndGet();
        }

        @Override
        public void getLastKnownLoginInfo() {
            this.getLastKnownLoginInfoCount.incrementAndGet();
        }

        @Override
        public void usersFlushedToDB(long count) {
            this.usersFlushedToDB.accept(count);
        }

        static class Settings {
            final LastValueSerializableStats<Boolean> legacyMode = new LastValueSerializableStats();
            final LastValueSerializableStats<Long> flushIntervalInSeconds = new LastValueSerializableStats();

            Settings() {
            }
        }
    }
}

