/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.component.pico.ComponentManager;
import com.google.common.collect.Maps;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraTypeUtils {
    private static final Logger log = LoggerFactory.getLogger(JiraTypeUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Map<String, T> loadTypes(String resource, Class<?> typeClass) {
        LinkedHashMap loadedTypes = Maps.newLinkedHashMap();
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)resource, typeClass);
        try {
            Document doc = new Document(is);
            Element root = doc.getRoot();
            Elements actions = root.getElements("type");
            while (actions.hasMoreElements()) {
                Element action = (Element)actions.nextElement();
                String id = action.getAttribute("id");
                String className = action.getElement("class").getTextString();
                try {
                    Class componentClass = ClassLoaderUtils.loadClass((String)className, typeClass);
                    loadedTypes.put(id, ComponentManager.getInstance().loadComponent(componentClass, Collections.emptyList()));
                }
                catch (Exception e) {
                    log.error("Exception loading type: " + className, (Throwable)e);
                }
            }
            LinkedHashMap linkedHashMap = loadedTypes;
            return linkedHashMap;
        }
        catch (ParseException e) {
            log.error("Parse exception parsing: " + resource, (Throwable)e);
            Map map = Collections.emptyMap();
            return map;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                log.warn("Could not close " + resource + " inputStream");
            }
        }
    }
}

